<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartPaymentMethodRequestParam StructType
 * @subpackage Structs
 */
class ShoppingCartPaymentMethodRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The quoteId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quoteId;
    /**
     * The paymentData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public $paymentData;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for shoppingCartPaymentMethodRequestParam
     * @uses ShoppingCartPaymentMethodRequestParam::setSessionId()
     * @uses ShoppingCartPaymentMethodRequestParam::setQuoteId()
     * @uses ShoppingCartPaymentMethodRequestParam::setPaymentData()
     * @uses ShoppingCartPaymentMethodRequestParam::setStore()
     * @param string $sessionId
     * @param int $quoteId
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity $paymentData
     * @param string $store
     */
    public function __construct($sessionId = null, $quoteId = null, \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity $paymentData = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setQuoteId($quoteId)
            ->setPaymentData($paymentData)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get quoteId value
     * @return int
     */
    public function getQuoteId()
    {
        return $this->quoteId;
    }
    /**
     * Set quoteId value
     * @param int $quoteId
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam
     */
    public function setQuoteId($quoteId = null)
    {
        // validation for constraint: int
        if (!is_null($quoteId) && !is_numeric($quoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quoteId)), __LINE__);
        }
        $this->quoteId = $quoteId;
        return $this;
    }
    /**
     * Get paymentData value
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function getPaymentData()
    {
        return $this->paymentData;
    }
    /**
     * Set paymentData value
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity $paymentData
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam
     */
    public function setPaymentData(\App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity $paymentData = null)
    {
        $this->paymentData = $paymentData;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
