<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartPaymentMethodEntity StructType
 * @subpackage Structs
 */
class ShoppingCartPaymentMethodEntity extends AbstractStructBase
{
    /**
     * The po_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $po_number;
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $method;
    /**
     * The cc_cid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc_cid;
    /**
     * The cc_owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc_owner;
    /**
     * The cc_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc_number;
    /**
     * The cc_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc_type;
    /**
     * The cc_exp_year
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc_exp_year;
    /**
     * The cc_exp_month
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cc_exp_month;
    /**
     * Constructor method for shoppingCartPaymentMethodEntity
     * @uses ShoppingCartPaymentMethodEntity::setPo_number()
     * @uses ShoppingCartPaymentMethodEntity::setMethod()
     * @uses ShoppingCartPaymentMethodEntity::setCc_cid()
     * @uses ShoppingCartPaymentMethodEntity::setCc_owner()
     * @uses ShoppingCartPaymentMethodEntity::setCc_number()
     * @uses ShoppingCartPaymentMethodEntity::setCc_type()
     * @uses ShoppingCartPaymentMethodEntity::setCc_exp_year()
     * @uses ShoppingCartPaymentMethodEntity::setCc_exp_month()
     * @param string $po_number
     * @param string $method
     * @param string $cc_cid
     * @param string $cc_owner
     * @param string $cc_number
     * @param string $cc_type
     * @param string $cc_exp_year
     * @param string $cc_exp_month
     */
    public function __construct($po_number = null, $method = null, $cc_cid = null, $cc_owner = null, $cc_number = null, $cc_type = null, $cc_exp_year = null, $cc_exp_month = null)
    {
        $this
            ->setPo_number($po_number)
            ->setMethod($method)
            ->setCc_cid($cc_cid)
            ->setCc_owner($cc_owner)
            ->setCc_number($cc_number)
            ->setCc_type($cc_type)
            ->setCc_exp_year($cc_exp_year)
            ->setCc_exp_month($cc_exp_month);
    }
    /**
     * Get po_number value
     * @return string|null
     */
    public function getPo_number()
    {
        return $this->po_number;
    }
    /**
     * Set po_number value
     * @param string $po_number
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setPo_number($po_number = null)
    {
        // validation for constraint: string
        if (!is_null($po_number) && !is_string($po_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($po_number)), __LINE__);
        }
        $this->po_number = $po_number;
        return $this;
    }
    /**
     * Get method value
     * @return string|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setMethod($method = null)
    {
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get cc_cid value
     * @return string|null
     */
    public function getCc_cid()
    {
        return $this->cc_cid;
    }
    /**
     * Set cc_cid value
     * @param string $cc_cid
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setCc_cid($cc_cid = null)
    {
        // validation for constraint: string
        if (!is_null($cc_cid) && !is_string($cc_cid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc_cid)), __LINE__);
        }
        $this->cc_cid = $cc_cid;
        return $this;
    }
    /**
     * Get cc_owner value
     * @return string|null
     */
    public function getCc_owner()
    {
        return $this->cc_owner;
    }
    /**
     * Set cc_owner value
     * @param string $cc_owner
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setCc_owner($cc_owner = null)
    {
        // validation for constraint: string
        if (!is_null($cc_owner) && !is_string($cc_owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc_owner)), __LINE__);
        }
        $this->cc_owner = $cc_owner;
        return $this;
    }
    /**
     * Get cc_number value
     * @return string|null
     */
    public function getCc_number()
    {
        return $this->cc_number;
    }
    /**
     * Set cc_number value
     * @param string $cc_number
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setCc_number($cc_number = null)
    {
        // validation for constraint: string
        if (!is_null($cc_number) && !is_string($cc_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc_number)), __LINE__);
        }
        $this->cc_number = $cc_number;
        return $this;
    }
    /**
     * Get cc_type value
     * @return string|null
     */
    public function getCc_type()
    {
        return $this->cc_type;
    }
    /**
     * Set cc_type value
     * @param string $cc_type
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setCc_type($cc_type = null)
    {
        // validation for constraint: string
        if (!is_null($cc_type) && !is_string($cc_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc_type)), __LINE__);
        }
        $this->cc_type = $cc_type;
        return $this;
    }
    /**
     * Get cc_exp_year value
     * @return string|null
     */
    public function getCc_exp_year()
    {
        return $this->cc_exp_year;
    }
    /**
     * Set cc_exp_year value
     * @param string $cc_exp_year
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setCc_exp_year($cc_exp_year = null)
    {
        // validation for constraint: string
        if (!is_null($cc_exp_year) && !is_string($cc_exp_year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc_exp_year)), __LINE__);
        }
        $this->cc_exp_year = $cc_exp_year;
        return $this;
    }
    /**
     * Get cc_exp_month value
     * @return string|null
     */
    public function getCc_exp_month()
    {
        return $this->cc_exp_month;
    }
    /**
     * Set cc_exp_month value
     * @param string $cc_exp_month
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public function setCc_exp_month($cc_exp_month = null)
    {
        // validation for constraint: string
        if (!is_null($cc_exp_month) && !is_string($cc_exp_month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cc_exp_month)), __LINE__);
        }
        $this->cc_exp_month = $cc_exp_month;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
