<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartLicenseEntity StructType
 * @subpackage Structs
 */
class ShoppingCartLicenseEntity extends AbstractStructBase
{
    /**
     * The agreement_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agreement_id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * The is_active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_active;
    /**
     * The is_html
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_html;
    /**
     * Constructor method for shoppingCartLicenseEntity
     * @uses ShoppingCartLicenseEntity::setAgreement_id()
     * @uses ShoppingCartLicenseEntity::setName()
     * @uses ShoppingCartLicenseEntity::setContent()
     * @uses ShoppingCartLicenseEntity::setIs_active()
     * @uses ShoppingCartLicenseEntity::setIs_html()
     * @param string $agreement_id
     * @param string $name
     * @param string $content
     * @param int $is_active
     * @param int $is_html
     */
    public function __construct($agreement_id = null, $name = null, $content = null, $is_active = null, $is_html = null)
    {
        $this
            ->setAgreement_id($agreement_id)
            ->setName($name)
            ->setContent($content)
            ->setIs_active($is_active)
            ->setIs_html($is_html);
    }
    /**
     * Get agreement_id value
     * @return string|null
     */
    public function getAgreement_id()
    {
        return $this->agreement_id;
    }
    /**
     * Set agreement_id value
     * @param string $agreement_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseEntity
     */
    public function setAgreement_id($agreement_id = null)
    {
        // validation for constraint: string
        if (!is_null($agreement_id) && !is_string($agreement_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agreement_id)), __LINE__);
        }
        $this->agreement_id = $agreement_id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseEntity
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get is_active value
     * @return int|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param int $is_active
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseEntity
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: int
        if (!is_null($is_active) && !is_numeric($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get is_html value
     * @return int|null
     */
    public function getIs_html()
    {
        return $this->is_html;
    }
    /**
     * Set is_html value
     * @param int $is_html
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseEntity
     */
    public function setIs_html($is_html = null)
    {
        // validation for constraint: int
        if (!is_null($is_html) && !is_numeric($is_html)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_html)), __LINE__);
        }
        $this->is_html = $is_html;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
