<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartInfoEntity StructType
 * @subpackage Structs
 */
class ShoppingCartInfoEntity extends AbstractStructBase
{
    /**
     * The store_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_id;
    /**
     * The created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created_at;
    /**
     * The updated_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updated_at;
    /**
     * The converted_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $converted_at;
    /**
     * The quote_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quote_id;
    /**
     * The is_active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_active;
    /**
     * The is_virtual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_virtual;
    /**
     * The is_multi_shipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_multi_shipping;
    /**
     * The items_count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $items_count;
    /**
     * The items_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $items_qty;
    /**
     * The orig_order_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orig_order_id;
    /**
     * The store_to_base_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_to_base_rate;
    /**
     * The store_to_quote_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_to_quote_rate;
    /**
     * The base_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_currency_code;
    /**
     * The store_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_currency_code;
    /**
     * The quote_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quote_currency_code;
    /**
     * The grand_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $grand_total;
    /**
     * The base_grand_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_grand_total;
    /**
     * The checkout_method
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $checkout_method;
    /**
     * The customer_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_id;
    /**
     * The customer_tax_class_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_tax_class_id;
    /**
     * The customer_group_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customer_group_id;
    /**
     * The customer_email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_email;
    /**
     * The customer_prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_prefix;
    /**
     * The customer_firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_firstname;
    /**
     * The customer_middlename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_middlename;
    /**
     * The customer_lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_lastname;
    /**
     * The customer_suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_suffix;
    /**
     * The customer_note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_note;
    /**
     * The customer_note_notify
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_note_notify;
    /**
     * The customer_is_guest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_is_guest;
    /**
     * The applied_rule_ids
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applied_rule_ids;
    /**
     * The reserved_order_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reserved_order_id;
    /**
     * The password_hash
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password_hash;
    /**
     * The coupon_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coupon_code;
    /**
     * The global_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $global_currency_code;
    /**
     * The base_to_global_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_to_global_rate;
    /**
     * The base_to_quote_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_to_quote_rate;
    /**
     * The customer_taxvat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_taxvat;
    /**
     * The customer_gender
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_gender;
    /**
     * The subtotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subtotal;
    /**
     * The base_subtotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_subtotal;
    /**
     * The subtotal_with_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subtotal_with_discount;
    /**
     * The base_subtotal_with_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_subtotal_with_discount;
    /**
     * The ext_shipping_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ext_shipping_info;
    /**
     * The gift_message_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message_id;
    /**
     * The gift_message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message;
    /**
     * The customer_balance_amount_used
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $customer_balance_amount_used;
    /**
     * The base_customer_balance_amount_used
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $base_customer_balance_amount_used;
    /**
     * The use_customer_balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $use_customer_balance;
    /**
     * The gift_cards_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_cards_amount;
    /**
     * The base_gift_cards_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_gift_cards_amount;
    /**
     * The gift_cards_amount_used
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_cards_amount_used;
    /**
     * The use_reward_points
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $use_reward_points;
    /**
     * The reward_points_balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reward_points_balance;
    /**
     * The base_reward_currency_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_reward_currency_amount;
    /**
     * The reward_currency_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reward_currency_amount;
    /**
     * The shipping_address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public $shipping_address;
    /**
     * The billing_address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity
     */
    public $billing_address;
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\ShoppingCartItemEntityArray
     */
    public $items;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentEntity
     */
    public $payment;
    /**
     * Constructor method for shoppingCartInfoEntity
     * @uses ShoppingCartInfoEntity::setStore_id()
     * @uses ShoppingCartInfoEntity::setCreated_at()
     * @uses ShoppingCartInfoEntity::setUpdated_at()
     * @uses ShoppingCartInfoEntity::setConverted_at()
     * @uses ShoppingCartInfoEntity::setQuote_id()
     * @uses ShoppingCartInfoEntity::setIs_active()
     * @uses ShoppingCartInfoEntity::setIs_virtual()
     * @uses ShoppingCartInfoEntity::setIs_multi_shipping()
     * @uses ShoppingCartInfoEntity::setItems_count()
     * @uses ShoppingCartInfoEntity::setItems_qty()
     * @uses ShoppingCartInfoEntity::setOrig_order_id()
     * @uses ShoppingCartInfoEntity::setStore_to_base_rate()
     * @uses ShoppingCartInfoEntity::setStore_to_quote_rate()
     * @uses ShoppingCartInfoEntity::setBase_currency_code()
     * @uses ShoppingCartInfoEntity::setStore_currency_code()
     * @uses ShoppingCartInfoEntity::setQuote_currency_code()
     * @uses ShoppingCartInfoEntity::setGrand_total()
     * @uses ShoppingCartInfoEntity::setBase_grand_total()
     * @uses ShoppingCartInfoEntity::setCheckout_method()
     * @uses ShoppingCartInfoEntity::setCustomer_id()
     * @uses ShoppingCartInfoEntity::setCustomer_tax_class_id()
     * @uses ShoppingCartInfoEntity::setCustomer_group_id()
     * @uses ShoppingCartInfoEntity::setCustomer_email()
     * @uses ShoppingCartInfoEntity::setCustomer_prefix()
     * @uses ShoppingCartInfoEntity::setCustomer_firstname()
     * @uses ShoppingCartInfoEntity::setCustomer_middlename()
     * @uses ShoppingCartInfoEntity::setCustomer_lastname()
     * @uses ShoppingCartInfoEntity::setCustomer_suffix()
     * @uses ShoppingCartInfoEntity::setCustomer_note()
     * @uses ShoppingCartInfoEntity::setCustomer_note_notify()
     * @uses ShoppingCartInfoEntity::setCustomer_is_guest()
     * @uses ShoppingCartInfoEntity::setApplied_rule_ids()
     * @uses ShoppingCartInfoEntity::setReserved_order_id()
     * @uses ShoppingCartInfoEntity::setPassword_hash()
     * @uses ShoppingCartInfoEntity::setCoupon_code()
     * @uses ShoppingCartInfoEntity::setGlobal_currency_code()
     * @uses ShoppingCartInfoEntity::setBase_to_global_rate()
     * @uses ShoppingCartInfoEntity::setBase_to_quote_rate()
     * @uses ShoppingCartInfoEntity::setCustomer_taxvat()
     * @uses ShoppingCartInfoEntity::setCustomer_gender()
     * @uses ShoppingCartInfoEntity::setSubtotal()
     * @uses ShoppingCartInfoEntity::setBase_subtotal()
     * @uses ShoppingCartInfoEntity::setSubtotal_with_discount()
     * @uses ShoppingCartInfoEntity::setBase_subtotal_with_discount()
     * @uses ShoppingCartInfoEntity::setExt_shipping_info()
     * @uses ShoppingCartInfoEntity::setGift_message_id()
     * @uses ShoppingCartInfoEntity::setGift_message()
     * @uses ShoppingCartInfoEntity::setCustomer_balance_amount_used()
     * @uses ShoppingCartInfoEntity::setBase_customer_balance_amount_used()
     * @uses ShoppingCartInfoEntity::setUse_customer_balance()
     * @uses ShoppingCartInfoEntity::setGift_cards_amount()
     * @uses ShoppingCartInfoEntity::setBase_gift_cards_amount()
     * @uses ShoppingCartInfoEntity::setGift_cards_amount_used()
     * @uses ShoppingCartInfoEntity::setUse_reward_points()
     * @uses ShoppingCartInfoEntity::setReward_points_balance()
     * @uses ShoppingCartInfoEntity::setBase_reward_currency_amount()
     * @uses ShoppingCartInfoEntity::setReward_currency_amount()
     * @uses ShoppingCartInfoEntity::setShipping_address()
     * @uses ShoppingCartInfoEntity::setBilling_address()
     * @uses ShoppingCartInfoEntity::setItems()
     * @uses ShoppingCartInfoEntity::setPayment()
     * @param string $store_id
     * @param string $created_at
     * @param string $updated_at
     * @param string $converted_at
     * @param int $quote_id
     * @param int $is_active
     * @param int $is_virtual
     * @param int $is_multi_shipping
     * @param float $items_count
     * @param float $items_qty
     * @param string $orig_order_id
     * @param string $store_to_base_rate
     * @param string $store_to_quote_rate
     * @param string $base_currency_code
     * @param string $store_currency_code
     * @param string $quote_currency_code
     * @param string $grand_total
     * @param string $base_grand_total
     * @param string $checkout_method
     * @param string $customer_id
     * @param string $customer_tax_class_id
     * @param int $customer_group_id
     * @param string $customer_email
     * @param string $customer_prefix
     * @param string $customer_firstname
     * @param string $customer_middlename
     * @param string $customer_lastname
     * @param string $customer_suffix
     * @param string $customer_note
     * @param string $customer_note_notify
     * @param string $customer_is_guest
     * @param string $applied_rule_ids
     * @param string $reserved_order_id
     * @param string $password_hash
     * @param string $coupon_code
     * @param string $global_currency_code
     * @param float $base_to_global_rate
     * @param float $base_to_quote_rate
     * @param string $customer_taxvat
     * @param string $customer_gender
     * @param float $subtotal
     * @param float $base_subtotal
     * @param float $subtotal_with_discount
     * @param float $base_subtotal_with_discount
     * @param string $ext_shipping_info
     * @param string $gift_message_id
     * @param string $gift_message
     * @param float $customer_balance_amount_used
     * @param float $base_customer_balance_amount_used
     * @param string $use_customer_balance
     * @param string $gift_cards_amount
     * @param string $base_gift_cards_amount
     * @param string $gift_cards_amount_used
     * @param string $use_reward_points
     * @param string $reward_points_balance
     * @param string $base_reward_currency_amount
     * @param string $reward_currency_amount
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $shipping_address
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $billing_address
     * @param \App\Api\Client\Magento\Type\ArrayType\ShoppingCartItemEntityArray $items
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentEntity $payment
     */
    public function __construct($store_id = null, $created_at = null, $updated_at = null, $converted_at = null, $quote_id = null, $is_active = null, $is_virtual = null, $is_multi_shipping = null, $items_count = null, $items_qty = null, $orig_order_id = null, $store_to_base_rate = null, $store_to_quote_rate = null, $base_currency_code = null, $store_currency_code = null, $quote_currency_code = null, $grand_total = null, $base_grand_total = null, $checkout_method = null, $customer_id = null, $customer_tax_class_id = null, $customer_group_id = null, $customer_email = null, $customer_prefix = null, $customer_firstname = null, $customer_middlename = null, $customer_lastname = null, $customer_suffix = null, $customer_note = null, $customer_note_notify = null, $customer_is_guest = null, $applied_rule_ids = null, $reserved_order_id = null, $password_hash = null, $coupon_code = null, $global_currency_code = null, $base_to_global_rate = null, $base_to_quote_rate = null, $customer_taxvat = null, $customer_gender = null, $subtotal = null, $base_subtotal = null, $subtotal_with_discount = null, $base_subtotal_with_discount = null, $ext_shipping_info = null, $gift_message_id = null, $gift_message = null, $customer_balance_amount_used = null, $base_customer_balance_amount_used = null, $use_customer_balance = null, $gift_cards_amount = null, $base_gift_cards_amount = null, $gift_cards_amount_used = null, $use_reward_points = null, $reward_points_balance = null, $base_reward_currency_amount = null, $reward_currency_amount = null, \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $shipping_address = null, \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $billing_address = null, \App\Api\Client\Magento\Type\ArrayType\ShoppingCartItemEntityArray $items = null, \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentEntity $payment = null)
    {
        $this
            ->setStore_id($store_id)
            ->setCreated_at($created_at)
            ->setUpdated_at($updated_at)
            ->setConverted_at($converted_at)
            ->setQuote_id($quote_id)
            ->setIs_active($is_active)
            ->setIs_virtual($is_virtual)
            ->setIs_multi_shipping($is_multi_shipping)
            ->setItems_count($items_count)
            ->setItems_qty($items_qty)
            ->setOrig_order_id($orig_order_id)
            ->setStore_to_base_rate($store_to_base_rate)
            ->setStore_to_quote_rate($store_to_quote_rate)
            ->setBase_currency_code($base_currency_code)
            ->setStore_currency_code($store_currency_code)
            ->setQuote_currency_code($quote_currency_code)
            ->setGrand_total($grand_total)
            ->setBase_grand_total($base_grand_total)
            ->setCheckout_method($checkout_method)
            ->setCustomer_id($customer_id)
            ->setCustomer_tax_class_id($customer_tax_class_id)
            ->setCustomer_group_id($customer_group_id)
            ->setCustomer_email($customer_email)
            ->setCustomer_prefix($customer_prefix)
            ->setCustomer_firstname($customer_firstname)
            ->setCustomer_middlename($customer_middlename)
            ->setCustomer_lastname($customer_lastname)
            ->setCustomer_suffix($customer_suffix)
            ->setCustomer_note($customer_note)
            ->setCustomer_note_notify($customer_note_notify)
            ->setCustomer_is_guest($customer_is_guest)
            ->setApplied_rule_ids($applied_rule_ids)
            ->setReserved_order_id($reserved_order_id)
            ->setPassword_hash($password_hash)
            ->setCoupon_code($coupon_code)
            ->setGlobal_currency_code($global_currency_code)
            ->setBase_to_global_rate($base_to_global_rate)
            ->setBase_to_quote_rate($base_to_quote_rate)
            ->setCustomer_taxvat($customer_taxvat)
            ->setCustomer_gender($customer_gender)
            ->setSubtotal($subtotal)
            ->setBase_subtotal($base_subtotal)
            ->setSubtotal_with_discount($subtotal_with_discount)
            ->setBase_subtotal_with_discount($base_subtotal_with_discount)
            ->setExt_shipping_info($ext_shipping_info)
            ->setGift_message_id($gift_message_id)
            ->setGift_message($gift_message)
            ->setCustomer_balance_amount_used($customer_balance_amount_used)
            ->setBase_customer_balance_amount_used($base_customer_balance_amount_used)
            ->setUse_customer_balance($use_customer_balance)
            ->setGift_cards_amount($gift_cards_amount)
            ->setBase_gift_cards_amount($base_gift_cards_amount)
            ->setGift_cards_amount_used($gift_cards_amount_used)
            ->setUse_reward_points($use_reward_points)
            ->setReward_points_balance($reward_points_balance)
            ->setBase_reward_currency_amount($base_reward_currency_amount)
            ->setReward_currency_amount($reward_currency_amount)
            ->setShipping_address($shipping_address)
            ->setBilling_address($billing_address)
            ->setItems($items)
            ->setPayment($payment);
    }
    /**
     * Get store_id value
     * @return string|null
     */
    public function getStore_id()
    {
        return $this->store_id;
    }
    /**
     * Set store_id value
     * @param string $store_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setStore_id($store_id = null)
    {
        // validation for constraint: string
        if (!is_null($store_id) && !is_string($store_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_id)), __LINE__);
        }
        $this->store_id = $store_id;
        return $this;
    }
    /**
     * Get created_at value
     * @return string|null
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get updated_at value
     * @return string|null
     */
    public function getUpdated_at()
    {
        return $this->updated_at;
    }
    /**
     * Set updated_at value
     * @param string $updated_at
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setUpdated_at($updated_at = null)
    {
        // validation for constraint: string
        if (!is_null($updated_at) && !is_string($updated_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated_at)), __LINE__);
        }
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Get converted_at value
     * @return string|null
     */
    public function getConverted_at()
    {
        return $this->converted_at;
    }
    /**
     * Set converted_at value
     * @param string $converted_at
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setConverted_at($converted_at = null)
    {
        // validation for constraint: string
        if (!is_null($converted_at) && !is_string($converted_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($converted_at)), __LINE__);
        }
        $this->converted_at = $converted_at;
        return $this;
    }
    /**
     * Get quote_id value
     * @return int|null
     */
    public function getQuote_id()
    {
        return $this->quote_id;
    }
    /**
     * Set quote_id value
     * @param int $quote_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setQuote_id($quote_id = null)
    {
        // validation for constraint: int
        if (!is_null($quote_id) && !is_numeric($quote_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quote_id)), __LINE__);
        }
        $this->quote_id = $quote_id;
        return $this;
    }
    /**
     * Get is_active value
     * @return int|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param int $is_active
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: int
        if (!is_null($is_active) && !is_numeric($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get is_virtual value
     * @return int|null
     */
    public function getIs_virtual()
    {
        return $this->is_virtual;
    }
    /**
     * Set is_virtual value
     * @param int $is_virtual
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setIs_virtual($is_virtual = null)
    {
        // validation for constraint: int
        if (!is_null($is_virtual) && !is_numeric($is_virtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_virtual)), __LINE__);
        }
        $this->is_virtual = $is_virtual;
        return $this;
    }
    /**
     * Get is_multi_shipping value
     * @return int|null
     */
    public function getIs_multi_shipping()
    {
        return $this->is_multi_shipping;
    }
    /**
     * Set is_multi_shipping value
     * @param int $is_multi_shipping
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setIs_multi_shipping($is_multi_shipping = null)
    {
        // validation for constraint: int
        if (!is_null($is_multi_shipping) && !is_numeric($is_multi_shipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_multi_shipping)), __LINE__);
        }
        $this->is_multi_shipping = $is_multi_shipping;
        return $this;
    }
    /**
     * Get items_count value
     * @return float|null
     */
    public function getItems_count()
    {
        return $this->items_count;
    }
    /**
     * Set items_count value
     * @param float $items_count
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setItems_count($items_count = null)
    {
        $this->items_count = $items_count;
        return $this;
    }
    /**
     * Get items_qty value
     * @return float|null
     */
    public function getItems_qty()
    {
        return $this->items_qty;
    }
    /**
     * Set items_qty value
     * @param float $items_qty
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setItems_qty($items_qty = null)
    {
        $this->items_qty = $items_qty;
        return $this;
    }
    /**
     * Get orig_order_id value
     * @return string|null
     */
    public function getOrig_order_id()
    {
        return $this->orig_order_id;
    }
    /**
     * Set orig_order_id value
     * @param string $orig_order_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setOrig_order_id($orig_order_id = null)
    {
        // validation for constraint: string
        if (!is_null($orig_order_id) && !is_string($orig_order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orig_order_id)), __LINE__);
        }
        $this->orig_order_id = $orig_order_id;
        return $this;
    }
    /**
     * Get store_to_base_rate value
     * @return string|null
     */
    public function getStore_to_base_rate()
    {
        return $this->store_to_base_rate;
    }
    /**
     * Set store_to_base_rate value
     * @param string $store_to_base_rate
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setStore_to_base_rate($store_to_base_rate = null)
    {
        // validation for constraint: string
        if (!is_null($store_to_base_rate) && !is_string($store_to_base_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_to_base_rate)), __LINE__);
        }
        $this->store_to_base_rate = $store_to_base_rate;
        return $this;
    }
    /**
     * Get store_to_quote_rate value
     * @return string|null
     */
    public function getStore_to_quote_rate()
    {
        return $this->store_to_quote_rate;
    }
    /**
     * Set store_to_quote_rate value
     * @param string $store_to_quote_rate
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setStore_to_quote_rate($store_to_quote_rate = null)
    {
        // validation for constraint: string
        if (!is_null($store_to_quote_rate) && !is_string($store_to_quote_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_to_quote_rate)), __LINE__);
        }
        $this->store_to_quote_rate = $store_to_quote_rate;
        return $this;
    }
    /**
     * Get base_currency_code value
     * @return string|null
     */
    public function getBase_currency_code()
    {
        return $this->base_currency_code;
    }
    /**
     * Set base_currency_code value
     * @param string $base_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_currency_code($base_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($base_currency_code) && !is_string($base_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_currency_code)), __LINE__);
        }
        $this->base_currency_code = $base_currency_code;
        return $this;
    }
    /**
     * Get store_currency_code value
     * @return string|null
     */
    public function getStore_currency_code()
    {
        return $this->store_currency_code;
    }
    /**
     * Set store_currency_code value
     * @param string $store_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setStore_currency_code($store_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($store_currency_code) && !is_string($store_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_currency_code)), __LINE__);
        }
        $this->store_currency_code = $store_currency_code;
        return $this;
    }
    /**
     * Get quote_currency_code value
     * @return string|null
     */
    public function getQuote_currency_code()
    {
        return $this->quote_currency_code;
    }
    /**
     * Set quote_currency_code value
     * @param string $quote_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setQuote_currency_code($quote_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($quote_currency_code) && !is_string($quote_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quote_currency_code)), __LINE__);
        }
        $this->quote_currency_code = $quote_currency_code;
        return $this;
    }
    /**
     * Get grand_total value
     * @return string|null
     */
    public function getGrand_total()
    {
        return $this->grand_total;
    }
    /**
     * Set grand_total value
     * @param string $grand_total
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setGrand_total($grand_total = null)
    {
        // validation for constraint: string
        if (!is_null($grand_total) && !is_string($grand_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grand_total)), __LINE__);
        }
        $this->grand_total = $grand_total;
        return $this;
    }
    /**
     * Get base_grand_total value
     * @return string|null
     */
    public function getBase_grand_total()
    {
        return $this->base_grand_total;
    }
    /**
     * Set base_grand_total value
     * @param string $base_grand_total
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_grand_total($base_grand_total = null)
    {
        // validation for constraint: string
        if (!is_null($base_grand_total) && !is_string($base_grand_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_grand_total)), __LINE__);
        }
        $this->base_grand_total = $base_grand_total;
        return $this;
    }
    /**
     * Get checkout_method value
     * @return string|null
     */
    public function getCheckout_method()
    {
        return $this->checkout_method;
    }
    /**
     * Set checkout_method value
     * @param string $checkout_method
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCheckout_method($checkout_method = null)
    {
        // validation for constraint: string
        if (!is_null($checkout_method) && !is_string($checkout_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkout_method)), __LINE__);
        }
        $this->checkout_method = $checkout_method;
        return $this;
    }
    /**
     * Get customer_id value
     * @return string|null
     */
    public function getCustomer_id()
    {
        return $this->customer_id;
    }
    /**
     * Set customer_id value
     * @param string $customer_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_id($customer_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_id) && !is_string($customer_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_id)), __LINE__);
        }
        $this->customer_id = $customer_id;
        return $this;
    }
    /**
     * Get customer_tax_class_id value
     * @return string|null
     */
    public function getCustomer_tax_class_id()
    {
        return $this->customer_tax_class_id;
    }
    /**
     * Set customer_tax_class_id value
     * @param string $customer_tax_class_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_tax_class_id($customer_tax_class_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_tax_class_id) && !is_string($customer_tax_class_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_tax_class_id)), __LINE__);
        }
        $this->customer_tax_class_id = $customer_tax_class_id;
        return $this;
    }
    /**
     * Get customer_group_id value
     * @return int|null
     */
    public function getCustomer_group_id()
    {
        return $this->customer_group_id;
    }
    /**
     * Set customer_group_id value
     * @param int $customer_group_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_group_id($customer_group_id = null)
    {
        // validation for constraint: int
        if (!is_null($customer_group_id) && !is_numeric($customer_group_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_group_id)), __LINE__);
        }
        $this->customer_group_id = $customer_group_id;
        return $this;
    }
    /**
     * Get customer_email value
     * @return string|null
     */
    public function getCustomer_email()
    {
        return $this->customer_email;
    }
    /**
     * Set customer_email value
     * @param string $customer_email
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_email($customer_email = null)
    {
        // validation for constraint: string
        if (!is_null($customer_email) && !is_string($customer_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_email)), __LINE__);
        }
        $this->customer_email = $customer_email;
        return $this;
    }
    /**
     * Get customer_prefix value
     * @return string|null
     */
    public function getCustomer_prefix()
    {
        return $this->customer_prefix;
    }
    /**
     * Set customer_prefix value
     * @param string $customer_prefix
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_prefix($customer_prefix = null)
    {
        // validation for constraint: string
        if (!is_null($customer_prefix) && !is_string($customer_prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_prefix)), __LINE__);
        }
        $this->customer_prefix = $customer_prefix;
        return $this;
    }
    /**
     * Get customer_firstname value
     * @return string|null
     */
    public function getCustomer_firstname()
    {
        return $this->customer_firstname;
    }
    /**
     * Set customer_firstname value
     * @param string $customer_firstname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_firstname($customer_firstname = null)
    {
        // validation for constraint: string
        if (!is_null($customer_firstname) && !is_string($customer_firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_firstname)), __LINE__);
        }
        $this->customer_firstname = $customer_firstname;
        return $this;
    }
    /**
     * Get customer_middlename value
     * @return string|null
     */
    public function getCustomer_middlename()
    {
        return $this->customer_middlename;
    }
    /**
     * Set customer_middlename value
     * @param string $customer_middlename
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_middlename($customer_middlename = null)
    {
        // validation for constraint: string
        if (!is_null($customer_middlename) && !is_string($customer_middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_middlename)), __LINE__);
        }
        $this->customer_middlename = $customer_middlename;
        return $this;
    }
    /**
     * Get customer_lastname value
     * @return string|null
     */
    public function getCustomer_lastname()
    {
        return $this->customer_lastname;
    }
    /**
     * Set customer_lastname value
     * @param string $customer_lastname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_lastname($customer_lastname = null)
    {
        // validation for constraint: string
        if (!is_null($customer_lastname) && !is_string($customer_lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_lastname)), __LINE__);
        }
        $this->customer_lastname = $customer_lastname;
        return $this;
    }
    /**
     * Get customer_suffix value
     * @return string|null
     */
    public function getCustomer_suffix()
    {
        return $this->customer_suffix;
    }
    /**
     * Set customer_suffix value
     * @param string $customer_suffix
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_suffix($customer_suffix = null)
    {
        // validation for constraint: string
        if (!is_null($customer_suffix) && !is_string($customer_suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_suffix)), __LINE__);
        }
        $this->customer_suffix = $customer_suffix;
        return $this;
    }
    /**
     * Get customer_note value
     * @return string|null
     */
    public function getCustomer_note()
    {
        return $this->customer_note;
    }
    /**
     * Set customer_note value
     * @param string $customer_note
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_note($customer_note = null)
    {
        // validation for constraint: string
        if (!is_null($customer_note) && !is_string($customer_note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_note)), __LINE__);
        }
        $this->customer_note = $customer_note;
        return $this;
    }
    /**
     * Get customer_note_notify value
     * @return string|null
     */
    public function getCustomer_note_notify()
    {
        return $this->customer_note_notify;
    }
    /**
     * Set customer_note_notify value
     * @param string $customer_note_notify
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_note_notify($customer_note_notify = null)
    {
        // validation for constraint: string
        if (!is_null($customer_note_notify) && !is_string($customer_note_notify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_note_notify)), __LINE__);
        }
        $this->customer_note_notify = $customer_note_notify;
        return $this;
    }
    /**
     * Get customer_is_guest value
     * @return string|null
     */
    public function getCustomer_is_guest()
    {
        return $this->customer_is_guest;
    }
    /**
     * Set customer_is_guest value
     * @param string $customer_is_guest
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_is_guest($customer_is_guest = null)
    {
        // validation for constraint: string
        if (!is_null($customer_is_guest) && !is_string($customer_is_guest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_is_guest)), __LINE__);
        }
        $this->customer_is_guest = $customer_is_guest;
        return $this;
    }
    /**
     * Get applied_rule_ids value
     * @return string|null
     */
    public function getApplied_rule_ids()
    {
        return $this->applied_rule_ids;
    }
    /**
     * Set applied_rule_ids value
     * @param string $applied_rule_ids
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setApplied_rule_ids($applied_rule_ids = null)
    {
        // validation for constraint: string
        if (!is_null($applied_rule_ids) && !is_string($applied_rule_ids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applied_rule_ids)), __LINE__);
        }
        $this->applied_rule_ids = $applied_rule_ids;
        return $this;
    }
    /**
     * Get reserved_order_id value
     * @return string|null
     */
    public function getReserved_order_id()
    {
        return $this->reserved_order_id;
    }
    /**
     * Set reserved_order_id value
     * @param string $reserved_order_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setReserved_order_id($reserved_order_id = null)
    {
        // validation for constraint: string
        if (!is_null($reserved_order_id) && !is_string($reserved_order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reserved_order_id)), __LINE__);
        }
        $this->reserved_order_id = $reserved_order_id;
        return $this;
    }
    /**
     * Get password_hash value
     * @return string|null
     */
    public function getPassword_hash()
    {
        return $this->password_hash;
    }
    /**
     * Set password_hash value
     * @param string $password_hash
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setPassword_hash($password_hash = null)
    {
        // validation for constraint: string
        if (!is_null($password_hash) && !is_string($password_hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password_hash)), __LINE__);
        }
        $this->password_hash = $password_hash;
        return $this;
    }
    /**
     * Get coupon_code value
     * @return string|null
     */
    public function getCoupon_code()
    {
        return $this->coupon_code;
    }
    /**
     * Set coupon_code value
     * @param string $coupon_code
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCoupon_code($coupon_code = null)
    {
        // validation for constraint: string
        if (!is_null($coupon_code) && !is_string($coupon_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coupon_code)), __LINE__);
        }
        $this->coupon_code = $coupon_code;
        return $this;
    }
    /**
     * Get global_currency_code value
     * @return string|null
     */
    public function getGlobal_currency_code()
    {
        return $this->global_currency_code;
    }
    /**
     * Set global_currency_code value
     * @param string $global_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setGlobal_currency_code($global_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($global_currency_code) && !is_string($global_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($global_currency_code)), __LINE__);
        }
        $this->global_currency_code = $global_currency_code;
        return $this;
    }
    /**
     * Get base_to_global_rate value
     * @return float|null
     */
    public function getBase_to_global_rate()
    {
        return $this->base_to_global_rate;
    }
    /**
     * Set base_to_global_rate value
     * @param float $base_to_global_rate
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_to_global_rate($base_to_global_rate = null)
    {
        $this->base_to_global_rate = $base_to_global_rate;
        return $this;
    }
    /**
     * Get base_to_quote_rate value
     * @return float|null
     */
    public function getBase_to_quote_rate()
    {
        return $this->base_to_quote_rate;
    }
    /**
     * Set base_to_quote_rate value
     * @param float $base_to_quote_rate
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_to_quote_rate($base_to_quote_rate = null)
    {
        $this->base_to_quote_rate = $base_to_quote_rate;
        return $this;
    }
    /**
     * Get customer_taxvat value
     * @return string|null
     */
    public function getCustomer_taxvat()
    {
        return $this->customer_taxvat;
    }
    /**
     * Set customer_taxvat value
     * @param string $customer_taxvat
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_taxvat($customer_taxvat = null)
    {
        // validation for constraint: string
        if (!is_null($customer_taxvat) && !is_string($customer_taxvat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_taxvat)), __LINE__);
        }
        $this->customer_taxvat = $customer_taxvat;
        return $this;
    }
    /**
     * Get customer_gender value
     * @return string|null
     */
    public function getCustomer_gender()
    {
        return $this->customer_gender;
    }
    /**
     * Set customer_gender value
     * @param string $customer_gender
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_gender($customer_gender = null)
    {
        // validation for constraint: string
        if (!is_null($customer_gender) && !is_string($customer_gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_gender)), __LINE__);
        }
        $this->customer_gender = $customer_gender;
        return $this;
    }
    /**
     * Get subtotal value
     * @return float|null
     */
    public function getSubtotal()
    {
        return $this->subtotal;
    }
    /**
     * Set subtotal value
     * @param float $subtotal
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setSubtotal($subtotal = null)
    {
        $this->subtotal = $subtotal;
        return $this;
    }
    /**
     * Get base_subtotal value
     * @return float|null
     */
    public function getBase_subtotal()
    {
        return $this->base_subtotal;
    }
    /**
     * Set base_subtotal value
     * @param float $base_subtotal
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_subtotal($base_subtotal = null)
    {
        $this->base_subtotal = $base_subtotal;
        return $this;
    }
    /**
     * Get subtotal_with_discount value
     * @return float|null
     */
    public function getSubtotal_with_discount()
    {
        return $this->subtotal_with_discount;
    }
    /**
     * Set subtotal_with_discount value
     * @param float $subtotal_with_discount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setSubtotal_with_discount($subtotal_with_discount = null)
    {
        $this->subtotal_with_discount = $subtotal_with_discount;
        return $this;
    }
    /**
     * Get base_subtotal_with_discount value
     * @return float|null
     */
    public function getBase_subtotal_with_discount()
    {
        return $this->base_subtotal_with_discount;
    }
    /**
     * Set base_subtotal_with_discount value
     * @param float $base_subtotal_with_discount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_subtotal_with_discount($base_subtotal_with_discount = null)
    {
        $this->base_subtotal_with_discount = $base_subtotal_with_discount;
        return $this;
    }
    /**
     * Get ext_shipping_info value
     * @return string|null
     */
    public function getExt_shipping_info()
    {
        return $this->ext_shipping_info;
    }
    /**
     * Set ext_shipping_info value
     * @param string $ext_shipping_info
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setExt_shipping_info($ext_shipping_info = null)
    {
        // validation for constraint: string
        if (!is_null($ext_shipping_info) && !is_string($ext_shipping_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ext_shipping_info)), __LINE__);
        }
        $this->ext_shipping_info = $ext_shipping_info;
        return $this;
    }
    /**
     * Get gift_message_id value
     * @return string|null
     */
    public function getGift_message_id()
    {
        return $this->gift_message_id;
    }
    /**
     * Set gift_message_id value
     * @param string $gift_message_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setGift_message_id($gift_message_id = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message_id) && !is_string($gift_message_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message_id)), __LINE__);
        }
        $this->gift_message_id = $gift_message_id;
        return $this;
    }
    /**
     * Get gift_message value
     * @return string|null
     */
    public function getGift_message()
    {
        return $this->gift_message;
    }
    /**
     * Set gift_message value
     * @param string $gift_message
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setGift_message($gift_message = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message) && !is_string($gift_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message)), __LINE__);
        }
        $this->gift_message = $gift_message;
        return $this;
    }
    /**
     * Get customer_balance_amount_used value
     * @return float|null
     */
    public function getCustomer_balance_amount_used()
    {
        return $this->customer_balance_amount_used;
    }
    /**
     * Set customer_balance_amount_used value
     * @param float $customer_balance_amount_used
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setCustomer_balance_amount_used($customer_balance_amount_used = null)
    {
        $this->customer_balance_amount_used = $customer_balance_amount_used;
        return $this;
    }
    /**
     * Get base_customer_balance_amount_used value
     * @return float|null
     */
    public function getBase_customer_balance_amount_used()
    {
        return $this->base_customer_balance_amount_used;
    }
    /**
     * Set base_customer_balance_amount_used value
     * @param float $base_customer_balance_amount_used
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_customer_balance_amount_used($base_customer_balance_amount_used = null)
    {
        $this->base_customer_balance_amount_used = $base_customer_balance_amount_used;
        return $this;
    }
    /**
     * Get use_customer_balance value
     * @return string|null
     */
    public function getUse_customer_balance()
    {
        return $this->use_customer_balance;
    }
    /**
     * Set use_customer_balance value
     * @param string $use_customer_balance
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setUse_customer_balance($use_customer_balance = null)
    {
        // validation for constraint: string
        if (!is_null($use_customer_balance) && !is_string($use_customer_balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($use_customer_balance)), __LINE__);
        }
        $this->use_customer_balance = $use_customer_balance;
        return $this;
    }
    /**
     * Get gift_cards_amount value
     * @return string|null
     */
    public function getGift_cards_amount()
    {
        return $this->gift_cards_amount;
    }
    /**
     * Set gift_cards_amount value
     * @param string $gift_cards_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setGift_cards_amount($gift_cards_amount = null)
    {
        // validation for constraint: string
        if (!is_null($gift_cards_amount) && !is_string($gift_cards_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_cards_amount)), __LINE__);
        }
        $this->gift_cards_amount = $gift_cards_amount;
        return $this;
    }
    /**
     * Get base_gift_cards_amount value
     * @return string|null
     */
    public function getBase_gift_cards_amount()
    {
        return $this->base_gift_cards_amount;
    }
    /**
     * Set base_gift_cards_amount value
     * @param string $base_gift_cards_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_gift_cards_amount($base_gift_cards_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_gift_cards_amount) && !is_string($base_gift_cards_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_gift_cards_amount)), __LINE__);
        }
        $this->base_gift_cards_amount = $base_gift_cards_amount;
        return $this;
    }
    /**
     * Get gift_cards_amount_used value
     * @return string|null
     */
    public function getGift_cards_amount_used()
    {
        return $this->gift_cards_amount_used;
    }
    /**
     * Set gift_cards_amount_used value
     * @param string $gift_cards_amount_used
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setGift_cards_amount_used($gift_cards_amount_used = null)
    {
        // validation for constraint: string
        if (!is_null($gift_cards_amount_used) && !is_string($gift_cards_amount_used)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_cards_amount_used)), __LINE__);
        }
        $this->gift_cards_amount_used = $gift_cards_amount_used;
        return $this;
    }
    /**
     * Get use_reward_points value
     * @return string|null
     */
    public function getUse_reward_points()
    {
        return $this->use_reward_points;
    }
    /**
     * Set use_reward_points value
     * @param string $use_reward_points
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setUse_reward_points($use_reward_points = null)
    {
        // validation for constraint: string
        if (!is_null($use_reward_points) && !is_string($use_reward_points)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($use_reward_points)), __LINE__);
        }
        $this->use_reward_points = $use_reward_points;
        return $this;
    }
    /**
     * Get reward_points_balance value
     * @return string|null
     */
    public function getReward_points_balance()
    {
        return $this->reward_points_balance;
    }
    /**
     * Set reward_points_balance value
     * @param string $reward_points_balance
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setReward_points_balance($reward_points_balance = null)
    {
        // validation for constraint: string
        if (!is_null($reward_points_balance) && !is_string($reward_points_balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reward_points_balance)), __LINE__);
        }
        $this->reward_points_balance = $reward_points_balance;
        return $this;
    }
    /**
     * Get base_reward_currency_amount value
     * @return string|null
     */
    public function getBase_reward_currency_amount()
    {
        return $this->base_reward_currency_amount;
    }
    /**
     * Set base_reward_currency_amount value
     * @param string $base_reward_currency_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBase_reward_currency_amount($base_reward_currency_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_reward_currency_amount) && !is_string($base_reward_currency_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_reward_currency_amount)), __LINE__);
        }
        $this->base_reward_currency_amount = $base_reward_currency_amount;
        return $this;
    }
    /**
     * Get reward_currency_amount value
     * @return string|null
     */
    public function getReward_currency_amount()
    {
        return $this->reward_currency_amount;
    }
    /**
     * Set reward_currency_amount value
     * @param string $reward_currency_amount
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setReward_currency_amount($reward_currency_amount = null)
    {
        // validation for constraint: string
        if (!is_null($reward_currency_amount) && !is_string($reward_currency_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reward_currency_amount)), __LINE__);
        }
        $this->reward_currency_amount = $reward_currency_amount;
        return $this;
    }
    /**
     * Get shipping_address value
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity|null
     */
    public function getShipping_address()
    {
        return $this->shipping_address;
    }
    /**
     * Set shipping_address value
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $shipping_address
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setShipping_address(\App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $shipping_address = null)
    {
        $this->shipping_address = $shipping_address;
        return $this;
    }
    /**
     * Get billing_address value
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity|null
     */
    public function getBilling_address()
    {
        return $this->billing_address;
    }
    /**
     * Set billing_address value
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $billing_address
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setBilling_address(\App\Api\Client\Magento\Type\StructType\ShoppingCartAddressEntity $billing_address = null)
    {
        $this->billing_address = $billing_address;
        return $this;
    }
    /**
     * Get items value
     * @return \App\Api\Client\Magento\Type\ArrayType\ShoppingCartItemEntityArray|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \App\Api\Client\Magento\Type\ArrayType\ShoppingCartItemEntityArray $items
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setItems(\App\Api\Client\Magento\Type\ArrayType\ShoppingCartItemEntityArray $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get payment value
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentEntity|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentEntity $payment
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public function setPayment(\App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentEntity $payment = null)
    {
        $this->payment = $payment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
