<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartCustomerEntity StructType
 * @subpackage Structs
 */
class ShoppingCartCustomerEntity extends AbstractStructBase
{
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mode;
    /**
     * The customer_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customer_id;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The confirmation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $confirmation;
    /**
     * The website_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $website_id;
    /**
     * The store_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $store_id;
    /**
     * The group_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $group_id;
    /**
     * Constructor method for shoppingCartCustomerEntity
     * @uses ShoppingCartCustomerEntity::setMode()
     * @uses ShoppingCartCustomerEntity::setCustomer_id()
     * @uses ShoppingCartCustomerEntity::setEmail()
     * @uses ShoppingCartCustomerEntity::setFirstname()
     * @uses ShoppingCartCustomerEntity::setLastname()
     * @uses ShoppingCartCustomerEntity::setPassword()
     * @uses ShoppingCartCustomerEntity::setConfirmation()
     * @uses ShoppingCartCustomerEntity::setWebsite_id()
     * @uses ShoppingCartCustomerEntity::setStore_id()
     * @uses ShoppingCartCustomerEntity::setGroup_id()
     * @param string $mode
     * @param int $customer_id
     * @param string $email
     * @param string $firstname
     * @param string $lastname
     * @param string $password
     * @param string $confirmation
     * @param int $website_id
     * @param int $store_id
     * @param int $group_id
     */
    public function __construct($mode = null, $customer_id = null, $email = null, $firstname = null, $lastname = null, $password = null, $confirmation = null, $website_id = null, $store_id = null, $group_id = null)
    {
        $this
            ->setMode($mode)
            ->setCustomer_id($customer_id)
            ->setEmail($email)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setPassword($password)
            ->setConfirmation($confirmation)
            ->setWebsite_id($website_id)
            ->setStore_id($store_id)
            ->setGroup_id($group_id);
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mode)), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get customer_id value
     * @return int|null
     */
    public function getCustomer_id()
    {
        return $this->customer_id;
    }
    /**
     * Set customer_id value
     * @param int $customer_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setCustomer_id($customer_id = null)
    {
        // validation for constraint: int
        if (!is_null($customer_id) && !is_numeric($customer_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_id)), __LINE__);
        }
        $this->customer_id = $customer_id;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get confirmation value
     * @return string|null
     */
    public function getConfirmation()
    {
        return $this->confirmation;
    }
    /**
     * Set confirmation value
     * @param string $confirmation
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setConfirmation($confirmation = null)
    {
        // validation for constraint: string
        if (!is_null($confirmation) && !is_string($confirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confirmation)), __LINE__);
        }
        $this->confirmation = $confirmation;
        return $this;
    }
    /**
     * Get website_id value
     * @return int|null
     */
    public function getWebsite_id()
    {
        return $this->website_id;
    }
    /**
     * Set website_id value
     * @param int $website_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setWebsite_id($website_id = null)
    {
        // validation for constraint: int
        if (!is_null($website_id) && !is_numeric($website_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($website_id)), __LINE__);
        }
        $this->website_id = $website_id;
        return $this;
    }
    /**
     * Get store_id value
     * @return int|null
     */
    public function getStore_id()
    {
        return $this->store_id;
    }
    /**
     * Set store_id value
     * @param int $store_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setStore_id($store_id = null)
    {
        // validation for constraint: int
        if (!is_null($store_id) && !is_numeric($store_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($store_id)), __LINE__);
        }
        $this->store_id = $store_id;
        return $this;
    }
    /**
     * Get group_id value
     * @return int|null
     */
    public function getGroup_id()
    {
        return $this->group_id;
    }
    /**
     * Set group_id value
     * @param int $group_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public function setGroup_id($group_id = null)
    {
        // validation for constraint: int
        if (!is_null($group_id) && !is_numeric($group_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($group_id)), __LINE__);
        }
        $this->group_id = $group_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
