<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartCustomerAddressEntity StructType
 * @subpackage Structs
 */
class ShoppingCartCustomerAddressEntity extends AbstractStructBase
{
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mode;
    /**
     * The address_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address_id;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $company;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The region_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region_id;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The country_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country_id;
    /**
     * The telephone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telephone;
    /**
     * The fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The is_default_billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_default_billing;
    /**
     * The is_default_shipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_default_shipping;
    /**
     * Constructor method for shoppingCartCustomerAddressEntity
     * @uses ShoppingCartCustomerAddressEntity::setMode()
     * @uses ShoppingCartCustomerAddressEntity::setAddress_id()
     * @uses ShoppingCartCustomerAddressEntity::setFirstname()
     * @uses ShoppingCartCustomerAddressEntity::setLastname()
     * @uses ShoppingCartCustomerAddressEntity::setCompany()
     * @uses ShoppingCartCustomerAddressEntity::setStreet()
     * @uses ShoppingCartCustomerAddressEntity::setCity()
     * @uses ShoppingCartCustomerAddressEntity::setRegion()
     * @uses ShoppingCartCustomerAddressEntity::setRegion_id()
     * @uses ShoppingCartCustomerAddressEntity::setPostcode()
     * @uses ShoppingCartCustomerAddressEntity::setCountry_id()
     * @uses ShoppingCartCustomerAddressEntity::setTelephone()
     * @uses ShoppingCartCustomerAddressEntity::setFax()
     * @uses ShoppingCartCustomerAddressEntity::setIs_default_billing()
     * @uses ShoppingCartCustomerAddressEntity::setIs_default_shipping()
     * @param string $mode
     * @param string $address_id
     * @param string $firstname
     * @param string $lastname
     * @param string $company
     * @param string $street
     * @param string $city
     * @param string $region
     * @param string $region_id
     * @param string $postcode
     * @param string $country_id
     * @param string $telephone
     * @param string $fax
     * @param int $is_default_billing
     * @param int $is_default_shipping
     */
    public function __construct($mode = null, $address_id = null, $firstname = null, $lastname = null, $company = null, $street = null, $city = null, $region = null, $region_id = null, $postcode = null, $country_id = null, $telephone = null, $fax = null, $is_default_billing = null, $is_default_shipping = null)
    {
        $this
            ->setMode($mode)
            ->setAddress_id($address_id)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setCompany($company)
            ->setStreet($street)
            ->setCity($city)
            ->setRegion($region)
            ->setRegion_id($region_id)
            ->setPostcode($postcode)
            ->setCountry_id($country_id)
            ->setTelephone($telephone)
            ->setFax($fax)
            ->setIs_default_billing($is_default_billing)
            ->setIs_default_shipping($is_default_shipping);
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mode)), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get address_id value
     * @return string|null
     */
    public function getAddress_id()
    {
        return $this->address_id;
    }
    /**
     * Set address_id value
     * @param string $address_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setAddress_id($address_id = null)
    {
        // validation for constraint: string
        if (!is_null($address_id) && !is_string($address_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address_id)), __LINE__);
        }
        $this->address_id = $address_id;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get region_id value
     * @return string|null
     */
    public function getRegion_id()
    {
        return $this->region_id;
    }
    /**
     * Set region_id value
     * @param string $region_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setRegion_id($region_id = null)
    {
        // validation for constraint: string
        if (!is_null($region_id) && !is_string($region_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region_id)), __LINE__);
        }
        $this->region_id = $region_id;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get country_id value
     * @return string|null
     */
    public function getCountry_id()
    {
        return $this->country_id;
    }
    /**
     * Set country_id value
     * @param string $country_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setCountry_id($country_id = null)
    {
        // validation for constraint: string
        if (!is_null($country_id) && !is_string($country_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_id)), __LINE__);
        }
        $this->country_id = $country_id;
        return $this;
    }
    /**
     * Get telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
    /**
     * Set telephone value
     * @param string $telephone
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->telephone = $telephone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get is_default_billing value
     * @return int|null
     */
    public function getIs_default_billing()
    {
        return $this->is_default_billing;
    }
    /**
     * Set is_default_billing value
     * @param int $is_default_billing
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setIs_default_billing($is_default_billing = null)
    {
        // validation for constraint: int
        if (!is_null($is_default_billing) && !is_numeric($is_default_billing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_default_billing)), __LINE__);
        }
        $this->is_default_billing = $is_default_billing;
        return $this;
    }
    /**
     * Get is_default_shipping value
     * @return int|null
     */
    public function getIs_default_shipping()
    {
        return $this->is_default_shipping;
    }
    /**
     * Set is_default_shipping value
     * @param int $is_default_shipping
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public function setIs_default_shipping($is_default_shipping = null)
    {
        // validation for constraint: int
        if (!is_null($is_default_shipping) && !is_numeric($is_default_shipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_default_shipping)), __LINE__);
        }
        $this->is_default_shipping = $is_default_shipping;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
