<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderShipmentRemoveTrackRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderShipmentRemoveTrackRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The shipmentIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shipmentIncrementId;
    /**
     * The trackId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trackId;
    /**
     * Constructor method for salesOrderShipmentRemoveTrackRequestParam
     * @uses SalesOrderShipmentRemoveTrackRequestParam::setSessionId()
     * @uses SalesOrderShipmentRemoveTrackRequestParam::setShipmentIncrementId()
     * @uses SalesOrderShipmentRemoveTrackRequestParam::setTrackId()
     * @param string $sessionId
     * @param string $shipmentIncrementId
     * @param string $trackId
     */
    public function __construct($sessionId = null, $shipmentIncrementId = null, $trackId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setShipmentIncrementId($shipmentIncrementId)
            ->setTrackId($trackId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get shipmentIncrementId value
     * @return string
     */
    public function getShipmentIncrementId()
    {
        return $this->shipmentIncrementId;
    }
    /**
     * Set shipmentIncrementId value
     * @param string $shipmentIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackRequestParam
     */
    public function setShipmentIncrementId($shipmentIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIncrementId) && !is_string($shipmentIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentIncrementId)), __LINE__);
        }
        $this->shipmentIncrementId = $shipmentIncrementId;
        return $this;
    }
    /**
     * Get trackId value
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }
    /**
     * Set trackId value
     * @param string $trackId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackRequestParam
     */
    public function setTrackId($trackId = null)
    {
        // validation for constraint: string
        if (!is_null($trackId) && !is_string($trackId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackId)), __LINE__);
        }
        $this->trackId = $trackId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
