<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderShipmentCreateRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderShipmentCreateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The orderIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $orderIncrementId;
    /**
     * The itemsQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\ArrayType\OrderItemIdQtyArray
     */
    public $itemsQty;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $email;
    /**
     * The includeComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $includeComment;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for salesOrderShipmentCreateRequestParam
     * @uses SalesOrderShipmentCreateRequestParam::setSessionId()
     * @uses SalesOrderShipmentCreateRequestParam::setOrderIncrementId()
     * @uses SalesOrderShipmentCreateRequestParam::setItemsQty()
     * @uses SalesOrderShipmentCreateRequestParam::setEmail()
     * @uses SalesOrderShipmentCreateRequestParam::setIncludeComment()
     * @uses SalesOrderShipmentCreateRequestParam::setComment()
     * @param string $sessionId
     * @param string $orderIncrementId
     * @param \App\Api\Client\Magento\Type\ArrayType\OrderItemIdQtyArray $itemsQty
     * @param int $email
     * @param int $includeComment
     * @param string $comment
     */
    public function __construct($sessionId = null, $orderIncrementId = null, \App\Api\Client\Magento\Type\ArrayType\OrderItemIdQtyArray $itemsQty = null, $email = null, $includeComment = null, $comment = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setOrderIncrementId($orderIncrementId)
            ->setItemsQty($itemsQty)
            ->setEmail($email)
            ->setIncludeComment($includeComment)
            ->setComment($comment);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get orderIncrementId value
     * @return string
     */
    public function getOrderIncrementId()
    {
        return $this->orderIncrementId;
    }
    /**
     * Set orderIncrementId value
     * @param string $orderIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam
     */
    public function setOrderIncrementId($orderIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($orderIncrementId) && !is_string($orderIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderIncrementId)), __LINE__);
        }
        $this->orderIncrementId = $orderIncrementId;
        return $this;
    }
    /**
     * Get itemsQty value
     * @return \App\Api\Client\Magento\Type\ArrayType\OrderItemIdQtyArray
     */
    public function getItemsQty()
    {
        return $this->itemsQty;
    }
    /**
     * Set itemsQty value
     * @param \App\Api\Client\Magento\Type\ArrayType\OrderItemIdQtyArray $itemsQty
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam
     */
    public function setItemsQty(\App\Api\Client\Magento\Type\ArrayType\OrderItemIdQtyArray $itemsQty = null)
    {
        $this->itemsQty = $itemsQty;
        return $this;
    }
    /**
     * Get email value
     * @return int
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param int $email
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam
     */
    public function setEmail($email = null)
    {
        // validation for constraint: int
        if (!is_null($email) && !is_numeric($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get includeComment value
     * @return int
     */
    public function getIncludeComment()
    {
        return $this->includeComment;
    }
    /**
     * Set includeComment value
     * @param int $includeComment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam
     */
    public function setIncludeComment($includeComment = null)
    {
        // validation for constraint: int
        if (!is_null($includeComment) && !is_numeric($includeComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($includeComment)), __LINE__);
        }
        $this->includeComment = $includeComment;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
