<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderShipmentAddTrackRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderShipmentAddTrackRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The shipmentIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shipmentIncrementId;
    /**
     * The carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $title;
    /**
     * The trackNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trackNumber;
    /**
     * Constructor method for salesOrderShipmentAddTrackRequestParam
     * @uses SalesOrderShipmentAddTrackRequestParam::setSessionId()
     * @uses SalesOrderShipmentAddTrackRequestParam::setShipmentIncrementId()
     * @uses SalesOrderShipmentAddTrackRequestParam::setCarrier()
     * @uses SalesOrderShipmentAddTrackRequestParam::setTitle()
     * @uses SalesOrderShipmentAddTrackRequestParam::setTrackNumber()
     * @param string $sessionId
     * @param string $shipmentIncrementId
     * @param string $carrier
     * @param string $title
     * @param string $trackNumber
     */
    public function __construct($sessionId = null, $shipmentIncrementId = null, $carrier = null, $title = null, $trackNumber = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setShipmentIncrementId($shipmentIncrementId)
            ->setCarrier($carrier)
            ->setTitle($title)
            ->setTrackNumber($trackNumber);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get shipmentIncrementId value
     * @return string
     */
    public function getShipmentIncrementId()
    {
        return $this->shipmentIncrementId;
    }
    /**
     * Set shipmentIncrementId value
     * @param string $shipmentIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam
     */
    public function setShipmentIncrementId($shipmentIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIncrementId) && !is_string($shipmentIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentIncrementId)), __LINE__);
        }
        $this->shipmentIncrementId = $shipmentIncrementId;
        return $this;
    }
    /**
     * Get carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @param string $carrier
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrier)), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get title value
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get trackNumber value
     * @return string
     */
    public function getTrackNumber()
    {
        return $this->trackNumber;
    }
    /**
     * Set trackNumber value
     * @param string $trackNumber
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam
     */
    public function setTrackNumber($trackNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackNumber) && !is_string($trackNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackNumber)), __LINE__);
        }
        $this->trackNumber = $trackNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
