<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderItemEntity StructType
 * @subpackage Structs
 */
class SalesOrderItemEntity extends AbstractStructBase
{
    /**
     * The item_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $item_id;
    /**
     * The order_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_id;
    /**
     * The quote_item_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quote_item_id;
    /**
     * The created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created_at;
    /**
     * The updated_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updated_at;
    /**
     * The product_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_id;
    /**
     * The product_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_type;
    /**
     * The product_options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_options;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weight;
    /**
     * The is_virtual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_virtual;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The applied_rule_ids
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applied_rule_ids;
    /**
     * The free_shipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $free_shipping;
    /**
     * The is_qty_decimal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_qty_decimal;
    /**
     * The no_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $no_discount;
    /**
     * The qty_canceled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty_canceled;
    /**
     * The qty_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty_invoiced;
    /**
     * The qty_ordered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty_ordered;
    /**
     * The qty_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty_refunded;
    /**
     * The qty_shipped
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty_shipped;
    /**
     * The cost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cost;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $price;
    /**
     * The base_price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_price;
    /**
     * The original_price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $original_price;
    /**
     * The base_original_price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_original_price;
    /**
     * The tax_percent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax_percent;
    /**
     * The tax_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax_amount;
    /**
     * The base_tax_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_tax_amount;
    /**
     * The tax_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax_invoiced;
    /**
     * The base_tax_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_tax_invoiced;
    /**
     * The discount_percent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discount_percent;
    /**
     * The discount_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discount_amount;
    /**
     * The base_discount_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_discount_amount;
    /**
     * The discount_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discount_invoiced;
    /**
     * The base_discount_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_discount_invoiced;
    /**
     * The amount_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amount_refunded;
    /**
     * The base_amount_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_amount_refunded;
    /**
     * The row_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $row_total;
    /**
     * The base_row_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_row_total;
    /**
     * The row_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $row_invoiced;
    /**
     * The base_row_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_row_invoiced;
    /**
     * The row_weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $row_weight;
    /**
     * The gift_message_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message_id;
    /**
     * The gift_message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message;
    /**
     * The gift_message_available
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message_available;
    /**
     * The base_tax_before_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_tax_before_discount;
    /**
     * The tax_before_discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax_before_discount;
    /**
     * The weee_tax_applied
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weee_tax_applied;
    /**
     * The weee_tax_applied_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weee_tax_applied_amount;
    /**
     * The weee_tax_applied_row_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weee_tax_applied_row_amount;
    /**
     * The base_weee_tax_applied_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_weee_tax_applied_amount;
    /**
     * The base_weee_tax_applied_row_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_weee_tax_applied_row_amount;
    /**
     * The weee_tax_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weee_tax_disposition;
    /**
     * The weee_tax_row_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weee_tax_row_disposition;
    /**
     * The base_weee_tax_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_weee_tax_disposition;
    /**
     * The base_weee_tax_row_disposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_weee_tax_row_disposition;
    /**
     * Constructor method for salesOrderItemEntity
     * @uses SalesOrderItemEntity::setItem_id()
     * @uses SalesOrderItemEntity::setOrder_id()
     * @uses SalesOrderItemEntity::setQuote_item_id()
     * @uses SalesOrderItemEntity::setCreated_at()
     * @uses SalesOrderItemEntity::setUpdated_at()
     * @uses SalesOrderItemEntity::setProduct_id()
     * @uses SalesOrderItemEntity::setProduct_type()
     * @uses SalesOrderItemEntity::setProduct_options()
     * @uses SalesOrderItemEntity::setWeight()
     * @uses SalesOrderItemEntity::setIs_virtual()
     * @uses SalesOrderItemEntity::setSku()
     * @uses SalesOrderItemEntity::setName()
     * @uses SalesOrderItemEntity::setApplied_rule_ids()
     * @uses SalesOrderItemEntity::setFree_shipping()
     * @uses SalesOrderItemEntity::setIs_qty_decimal()
     * @uses SalesOrderItemEntity::setNo_discount()
     * @uses SalesOrderItemEntity::setQty_canceled()
     * @uses SalesOrderItemEntity::setQty_invoiced()
     * @uses SalesOrderItemEntity::setQty_ordered()
     * @uses SalesOrderItemEntity::setQty_refunded()
     * @uses SalesOrderItemEntity::setQty_shipped()
     * @uses SalesOrderItemEntity::setCost()
     * @uses SalesOrderItemEntity::setPrice()
     * @uses SalesOrderItemEntity::setBase_price()
     * @uses SalesOrderItemEntity::setOriginal_price()
     * @uses SalesOrderItemEntity::setBase_original_price()
     * @uses SalesOrderItemEntity::setTax_percent()
     * @uses SalesOrderItemEntity::setTax_amount()
     * @uses SalesOrderItemEntity::setBase_tax_amount()
     * @uses SalesOrderItemEntity::setTax_invoiced()
     * @uses SalesOrderItemEntity::setBase_tax_invoiced()
     * @uses SalesOrderItemEntity::setDiscount_percent()
     * @uses SalesOrderItemEntity::setDiscount_amount()
     * @uses SalesOrderItemEntity::setBase_discount_amount()
     * @uses SalesOrderItemEntity::setDiscount_invoiced()
     * @uses SalesOrderItemEntity::setBase_discount_invoiced()
     * @uses SalesOrderItemEntity::setAmount_refunded()
     * @uses SalesOrderItemEntity::setBase_amount_refunded()
     * @uses SalesOrderItemEntity::setRow_total()
     * @uses SalesOrderItemEntity::setBase_row_total()
     * @uses SalesOrderItemEntity::setRow_invoiced()
     * @uses SalesOrderItemEntity::setBase_row_invoiced()
     * @uses SalesOrderItemEntity::setRow_weight()
     * @uses SalesOrderItemEntity::setGift_message_id()
     * @uses SalesOrderItemEntity::setGift_message()
     * @uses SalesOrderItemEntity::setGift_message_available()
     * @uses SalesOrderItemEntity::setBase_tax_before_discount()
     * @uses SalesOrderItemEntity::setTax_before_discount()
     * @uses SalesOrderItemEntity::setWeee_tax_applied()
     * @uses SalesOrderItemEntity::setWeee_tax_applied_amount()
     * @uses SalesOrderItemEntity::setWeee_tax_applied_row_amount()
     * @uses SalesOrderItemEntity::setBase_weee_tax_applied_amount()
     * @uses SalesOrderItemEntity::setBase_weee_tax_applied_row_amount()
     * @uses SalesOrderItemEntity::setWeee_tax_disposition()
     * @uses SalesOrderItemEntity::setWeee_tax_row_disposition()
     * @uses SalesOrderItemEntity::setBase_weee_tax_disposition()
     * @uses SalesOrderItemEntity::setBase_weee_tax_row_disposition()
     * @param string $item_id
     * @param string $order_id
     * @param string $quote_item_id
     * @param string $created_at
     * @param string $updated_at
     * @param string $product_id
     * @param string $product_type
     * @param string $product_options
     * @param string $weight
     * @param string $is_virtual
     * @param string $sku
     * @param string $name
     * @param string $applied_rule_ids
     * @param string $free_shipping
     * @param string $is_qty_decimal
     * @param string $no_discount
     * @param string $qty_canceled
     * @param string $qty_invoiced
     * @param string $qty_ordered
     * @param string $qty_refunded
     * @param string $qty_shipped
     * @param string $cost
     * @param string $price
     * @param string $base_price
     * @param string $original_price
     * @param string $base_original_price
     * @param string $tax_percent
     * @param string $tax_amount
     * @param string $base_tax_amount
     * @param string $tax_invoiced
     * @param string $base_tax_invoiced
     * @param string $discount_percent
     * @param string $discount_amount
     * @param string $base_discount_amount
     * @param string $discount_invoiced
     * @param string $base_discount_invoiced
     * @param string $amount_refunded
     * @param string $base_amount_refunded
     * @param string $row_total
     * @param string $base_row_total
     * @param string $row_invoiced
     * @param string $base_row_invoiced
     * @param string $row_weight
     * @param string $gift_message_id
     * @param string $gift_message
     * @param string $gift_message_available
     * @param string $base_tax_before_discount
     * @param string $tax_before_discount
     * @param string $weee_tax_applied
     * @param string $weee_tax_applied_amount
     * @param string $weee_tax_applied_row_amount
     * @param string $base_weee_tax_applied_amount
     * @param string $base_weee_tax_applied_row_amount
     * @param string $weee_tax_disposition
     * @param string $weee_tax_row_disposition
     * @param string $base_weee_tax_disposition
     * @param string $base_weee_tax_row_disposition
     */
    public function __construct($item_id = null, $order_id = null, $quote_item_id = null, $created_at = null, $updated_at = null, $product_id = null, $product_type = null, $product_options = null, $weight = null, $is_virtual = null, $sku = null, $name = null, $applied_rule_ids = null, $free_shipping = null, $is_qty_decimal = null, $no_discount = null, $qty_canceled = null, $qty_invoiced = null, $qty_ordered = null, $qty_refunded = null, $qty_shipped = null, $cost = null, $price = null, $base_price = null, $original_price = null, $base_original_price = null, $tax_percent = null, $tax_amount = null, $base_tax_amount = null, $tax_invoiced = null, $base_tax_invoiced = null, $discount_percent = null, $discount_amount = null, $base_discount_amount = null, $discount_invoiced = null, $base_discount_invoiced = null, $amount_refunded = null, $base_amount_refunded = null, $row_total = null, $base_row_total = null, $row_invoiced = null, $base_row_invoiced = null, $row_weight = null, $gift_message_id = null, $gift_message = null, $gift_message_available = null, $base_tax_before_discount = null, $tax_before_discount = null, $weee_tax_applied = null, $weee_tax_applied_amount = null, $weee_tax_applied_row_amount = null, $base_weee_tax_applied_amount = null, $base_weee_tax_applied_row_amount = null, $weee_tax_disposition = null, $weee_tax_row_disposition = null, $base_weee_tax_disposition = null, $base_weee_tax_row_disposition = null)
    {
        $this
            ->setItem_id($item_id)
            ->setOrder_id($order_id)
            ->setQuote_item_id($quote_item_id)
            ->setCreated_at($created_at)
            ->setUpdated_at($updated_at)
            ->setProduct_id($product_id)
            ->setProduct_type($product_type)
            ->setProduct_options($product_options)
            ->setWeight($weight)
            ->setIs_virtual($is_virtual)
            ->setSku($sku)
            ->setName($name)
            ->setApplied_rule_ids($applied_rule_ids)
            ->setFree_shipping($free_shipping)
            ->setIs_qty_decimal($is_qty_decimal)
            ->setNo_discount($no_discount)
            ->setQty_canceled($qty_canceled)
            ->setQty_invoiced($qty_invoiced)
            ->setQty_ordered($qty_ordered)
            ->setQty_refunded($qty_refunded)
            ->setQty_shipped($qty_shipped)
            ->setCost($cost)
            ->setPrice($price)
            ->setBase_price($base_price)
            ->setOriginal_price($original_price)
            ->setBase_original_price($base_original_price)
            ->setTax_percent($tax_percent)
            ->setTax_amount($tax_amount)
            ->setBase_tax_amount($base_tax_amount)
            ->setTax_invoiced($tax_invoiced)
            ->setBase_tax_invoiced($base_tax_invoiced)
            ->setDiscount_percent($discount_percent)
            ->setDiscount_amount($discount_amount)
            ->setBase_discount_amount($base_discount_amount)
            ->setDiscount_invoiced($discount_invoiced)
            ->setBase_discount_invoiced($base_discount_invoiced)
            ->setAmount_refunded($amount_refunded)
            ->setBase_amount_refunded($base_amount_refunded)
            ->setRow_total($row_total)
            ->setBase_row_total($base_row_total)
            ->setRow_invoiced($row_invoiced)
            ->setBase_row_invoiced($base_row_invoiced)
            ->setRow_weight($row_weight)
            ->setGift_message_id($gift_message_id)
            ->setGift_message($gift_message)
            ->setGift_message_available($gift_message_available)
            ->setBase_tax_before_discount($base_tax_before_discount)
            ->setTax_before_discount($tax_before_discount)
            ->setWeee_tax_applied($weee_tax_applied)
            ->setWeee_tax_applied_amount($weee_tax_applied_amount)
            ->setWeee_tax_applied_row_amount($weee_tax_applied_row_amount)
            ->setBase_weee_tax_applied_amount($base_weee_tax_applied_amount)
            ->setBase_weee_tax_applied_row_amount($base_weee_tax_applied_row_amount)
            ->setWeee_tax_disposition($weee_tax_disposition)
            ->setWeee_tax_row_disposition($weee_tax_row_disposition)
            ->setBase_weee_tax_disposition($base_weee_tax_disposition)
            ->setBase_weee_tax_row_disposition($base_weee_tax_row_disposition);
    }
    /**
     * Get item_id value
     * @return string|null
     */
    public function getItem_id()
    {
        return $this->item_id;
    }
    /**
     * Set item_id value
     * @param string $item_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setItem_id($item_id = null)
    {
        // validation for constraint: string
        if (!is_null($item_id) && !is_string($item_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($item_id)), __LINE__);
        }
        $this->item_id = $item_id;
        return $this;
    }
    /**
     * Get order_id value
     * @return string|null
     */
    public function getOrder_id()
    {
        return $this->order_id;
    }
    /**
     * Set order_id value
     * @param string $order_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_id)), __LINE__);
        }
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Get quote_item_id value
     * @return string|null
     */
    public function getQuote_item_id()
    {
        return $this->quote_item_id;
    }
    /**
     * Set quote_item_id value
     * @param string $quote_item_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setQuote_item_id($quote_item_id = null)
    {
        // validation for constraint: string
        if (!is_null($quote_item_id) && !is_string($quote_item_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quote_item_id)), __LINE__);
        }
        $this->quote_item_id = $quote_item_id;
        return $this;
    }
    /**
     * Get created_at value
     * @return string|null
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get updated_at value
     * @return string|null
     */
    public function getUpdated_at()
    {
        return $this->updated_at;
    }
    /**
     * Set updated_at value
     * @param string $updated_at
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setUpdated_at($updated_at = null)
    {
        // validation for constraint: string
        if (!is_null($updated_at) && !is_string($updated_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated_at)), __LINE__);
        }
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Get product_id value
     * @return string|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get product_type value
     * @return string|null
     */
    public function getProduct_type()
    {
        return $this->product_type;
    }
    /**
     * Set product_type value
     * @param string $product_type
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setProduct_type($product_type = null)
    {
        // validation for constraint: string
        if (!is_null($product_type) && !is_string($product_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_type)), __LINE__);
        }
        $this->product_type = $product_type;
        return $this;
    }
    /**
     * Get product_options value
     * @return string|null
     */
    public function getProduct_options()
    {
        return $this->product_options;
    }
    /**
     * Set product_options value
     * @param string $product_options
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setProduct_options($product_options = null)
    {
        // validation for constraint: string
        if (!is_null($product_options) && !is_string($product_options)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_options)), __LINE__);
        }
        $this->product_options = $product_options;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get is_virtual value
     * @return string|null
     */
    public function getIs_virtual()
    {
        return $this->is_virtual;
    }
    /**
     * Set is_virtual value
     * @param string $is_virtual
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setIs_virtual($is_virtual = null)
    {
        // validation for constraint: string
        if (!is_null($is_virtual) && !is_string($is_virtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_virtual)), __LINE__);
        }
        $this->is_virtual = $is_virtual;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get applied_rule_ids value
     * @return string|null
     */
    public function getApplied_rule_ids()
    {
        return $this->applied_rule_ids;
    }
    /**
     * Set applied_rule_ids value
     * @param string $applied_rule_ids
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setApplied_rule_ids($applied_rule_ids = null)
    {
        // validation for constraint: string
        if (!is_null($applied_rule_ids) && !is_string($applied_rule_ids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applied_rule_ids)), __LINE__);
        }
        $this->applied_rule_ids = $applied_rule_ids;
        return $this;
    }
    /**
     * Get free_shipping value
     * @return string|null
     */
    public function getFree_shipping()
    {
        return $this->free_shipping;
    }
    /**
     * Set free_shipping value
     * @param string $free_shipping
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setFree_shipping($free_shipping = null)
    {
        // validation for constraint: string
        if (!is_null($free_shipping) && !is_string($free_shipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($free_shipping)), __LINE__);
        }
        $this->free_shipping = $free_shipping;
        return $this;
    }
    /**
     * Get is_qty_decimal value
     * @return string|null
     */
    public function getIs_qty_decimal()
    {
        return $this->is_qty_decimal;
    }
    /**
     * Set is_qty_decimal value
     * @param string $is_qty_decimal
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setIs_qty_decimal($is_qty_decimal = null)
    {
        // validation for constraint: string
        if (!is_null($is_qty_decimal) && !is_string($is_qty_decimal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_qty_decimal)), __LINE__);
        }
        $this->is_qty_decimal = $is_qty_decimal;
        return $this;
    }
    /**
     * Get no_discount value
     * @return string|null
     */
    public function getNo_discount()
    {
        return $this->no_discount;
    }
    /**
     * Set no_discount value
     * @param string $no_discount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setNo_discount($no_discount = null)
    {
        // validation for constraint: string
        if (!is_null($no_discount) && !is_string($no_discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($no_discount)), __LINE__);
        }
        $this->no_discount = $no_discount;
        return $this;
    }
    /**
     * Get qty_canceled value
     * @return string|null
     */
    public function getQty_canceled()
    {
        return $this->qty_canceled;
    }
    /**
     * Set qty_canceled value
     * @param string $qty_canceled
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setQty_canceled($qty_canceled = null)
    {
        // validation for constraint: string
        if (!is_null($qty_canceled) && !is_string($qty_canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty_canceled)), __LINE__);
        }
        $this->qty_canceled = $qty_canceled;
        return $this;
    }
    /**
     * Get qty_invoiced value
     * @return string|null
     */
    public function getQty_invoiced()
    {
        return $this->qty_invoiced;
    }
    /**
     * Set qty_invoiced value
     * @param string $qty_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setQty_invoiced($qty_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($qty_invoiced) && !is_string($qty_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty_invoiced)), __LINE__);
        }
        $this->qty_invoiced = $qty_invoiced;
        return $this;
    }
    /**
     * Get qty_ordered value
     * @return string|null
     */
    public function getQty_ordered()
    {
        return $this->qty_ordered;
    }
    /**
     * Set qty_ordered value
     * @param string $qty_ordered
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setQty_ordered($qty_ordered = null)
    {
        // validation for constraint: string
        if (!is_null($qty_ordered) && !is_string($qty_ordered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty_ordered)), __LINE__);
        }
        $this->qty_ordered = $qty_ordered;
        return $this;
    }
    /**
     * Get qty_refunded value
     * @return string|null
     */
    public function getQty_refunded()
    {
        return $this->qty_refunded;
    }
    /**
     * Set qty_refunded value
     * @param string $qty_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setQty_refunded($qty_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($qty_refunded) && !is_string($qty_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty_refunded)), __LINE__);
        }
        $this->qty_refunded = $qty_refunded;
        return $this;
    }
    /**
     * Get qty_shipped value
     * @return string|null
     */
    public function getQty_shipped()
    {
        return $this->qty_shipped;
    }
    /**
     * Set qty_shipped value
     * @param string $qty_shipped
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setQty_shipped($qty_shipped = null)
    {
        // validation for constraint: string
        if (!is_null($qty_shipped) && !is_string($qty_shipped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty_shipped)), __LINE__);
        }
        $this->qty_shipped = $qty_shipped;
        return $this;
    }
    /**
     * Get cost value
     * @return string|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param string $cost
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setCost($cost = null)
    {
        // validation for constraint: string
        if (!is_null($cost) && !is_string($cost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get price value
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get base_price value
     * @return string|null
     */
    public function getBase_price()
    {
        return $this->base_price;
    }
    /**
     * Set base_price value
     * @param string $base_price
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_price($base_price = null)
    {
        // validation for constraint: string
        if (!is_null($base_price) && !is_string($base_price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_price)), __LINE__);
        }
        $this->base_price = $base_price;
        return $this;
    }
    /**
     * Get original_price value
     * @return string|null
     */
    public function getOriginal_price()
    {
        return $this->original_price;
    }
    /**
     * Set original_price value
     * @param string $original_price
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setOriginal_price($original_price = null)
    {
        // validation for constraint: string
        if (!is_null($original_price) && !is_string($original_price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($original_price)), __LINE__);
        }
        $this->original_price = $original_price;
        return $this;
    }
    /**
     * Get base_original_price value
     * @return string|null
     */
    public function getBase_original_price()
    {
        return $this->base_original_price;
    }
    /**
     * Set base_original_price value
     * @param string $base_original_price
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_original_price($base_original_price = null)
    {
        // validation for constraint: string
        if (!is_null($base_original_price) && !is_string($base_original_price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_original_price)), __LINE__);
        }
        $this->base_original_price = $base_original_price;
        return $this;
    }
    /**
     * Get tax_percent value
     * @return string|null
     */
    public function getTax_percent()
    {
        return $this->tax_percent;
    }
    /**
     * Set tax_percent value
     * @param string $tax_percent
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setTax_percent($tax_percent = null)
    {
        // validation for constraint: string
        if (!is_null($tax_percent) && !is_string($tax_percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_percent)), __LINE__);
        }
        $this->tax_percent = $tax_percent;
        return $this;
    }
    /**
     * Get tax_amount value
     * @return string|null
     */
    public function getTax_amount()
    {
        return $this->tax_amount;
    }
    /**
     * Set tax_amount value
     * @param string $tax_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setTax_amount($tax_amount = null)
    {
        // validation for constraint: string
        if (!is_null($tax_amount) && !is_string($tax_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_amount)), __LINE__);
        }
        $this->tax_amount = $tax_amount;
        return $this;
    }
    /**
     * Get base_tax_amount value
     * @return string|null
     */
    public function getBase_tax_amount()
    {
        return $this->base_tax_amount;
    }
    /**
     * Set base_tax_amount value
     * @param string $base_tax_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_tax_amount($base_tax_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_tax_amount) && !is_string($base_tax_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_tax_amount)), __LINE__);
        }
        $this->base_tax_amount = $base_tax_amount;
        return $this;
    }
    /**
     * Get tax_invoiced value
     * @return string|null
     */
    public function getTax_invoiced()
    {
        return $this->tax_invoiced;
    }
    /**
     * Set tax_invoiced value
     * @param string $tax_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setTax_invoiced($tax_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($tax_invoiced) && !is_string($tax_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_invoiced)), __LINE__);
        }
        $this->tax_invoiced = $tax_invoiced;
        return $this;
    }
    /**
     * Get base_tax_invoiced value
     * @return string|null
     */
    public function getBase_tax_invoiced()
    {
        return $this->base_tax_invoiced;
    }
    /**
     * Set base_tax_invoiced value
     * @param string $base_tax_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_tax_invoiced($base_tax_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($base_tax_invoiced) && !is_string($base_tax_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_tax_invoiced)), __LINE__);
        }
        $this->base_tax_invoiced = $base_tax_invoiced;
        return $this;
    }
    /**
     * Get discount_percent value
     * @return string|null
     */
    public function getDiscount_percent()
    {
        return $this->discount_percent;
    }
    /**
     * Set discount_percent value
     * @param string $discount_percent
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setDiscount_percent($discount_percent = null)
    {
        // validation for constraint: string
        if (!is_null($discount_percent) && !is_string($discount_percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discount_percent)), __LINE__);
        }
        $this->discount_percent = $discount_percent;
        return $this;
    }
    /**
     * Get discount_amount value
     * @return string|null
     */
    public function getDiscount_amount()
    {
        return $this->discount_amount;
    }
    /**
     * Set discount_amount value
     * @param string $discount_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setDiscount_amount($discount_amount = null)
    {
        // validation for constraint: string
        if (!is_null($discount_amount) && !is_string($discount_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discount_amount)), __LINE__);
        }
        $this->discount_amount = $discount_amount;
        return $this;
    }
    /**
     * Get base_discount_amount value
     * @return string|null
     */
    public function getBase_discount_amount()
    {
        return $this->base_discount_amount;
    }
    /**
     * Set base_discount_amount value
     * @param string $base_discount_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_discount_amount($base_discount_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_discount_amount) && !is_string($base_discount_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_discount_amount)), __LINE__);
        }
        $this->base_discount_amount = $base_discount_amount;
        return $this;
    }
    /**
     * Get discount_invoiced value
     * @return string|null
     */
    public function getDiscount_invoiced()
    {
        return $this->discount_invoiced;
    }
    /**
     * Set discount_invoiced value
     * @param string $discount_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setDiscount_invoiced($discount_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($discount_invoiced) && !is_string($discount_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discount_invoiced)), __LINE__);
        }
        $this->discount_invoiced = $discount_invoiced;
        return $this;
    }
    /**
     * Get base_discount_invoiced value
     * @return string|null
     */
    public function getBase_discount_invoiced()
    {
        return $this->base_discount_invoiced;
    }
    /**
     * Set base_discount_invoiced value
     * @param string $base_discount_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_discount_invoiced($base_discount_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($base_discount_invoiced) && !is_string($base_discount_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_discount_invoiced)), __LINE__);
        }
        $this->base_discount_invoiced = $base_discount_invoiced;
        return $this;
    }
    /**
     * Get amount_refunded value
     * @return string|null
     */
    public function getAmount_refunded()
    {
        return $this->amount_refunded;
    }
    /**
     * Set amount_refunded value
     * @param string $amount_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setAmount_refunded($amount_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($amount_refunded) && !is_string($amount_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amount_refunded)), __LINE__);
        }
        $this->amount_refunded = $amount_refunded;
        return $this;
    }
    /**
     * Get base_amount_refunded value
     * @return string|null
     */
    public function getBase_amount_refunded()
    {
        return $this->base_amount_refunded;
    }
    /**
     * Set base_amount_refunded value
     * @param string $base_amount_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_amount_refunded($base_amount_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($base_amount_refunded) && !is_string($base_amount_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_amount_refunded)), __LINE__);
        }
        $this->base_amount_refunded = $base_amount_refunded;
        return $this;
    }
    /**
     * Get row_total value
     * @return string|null
     */
    public function getRow_total()
    {
        return $this->row_total;
    }
    /**
     * Set row_total value
     * @param string $row_total
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setRow_total($row_total = null)
    {
        // validation for constraint: string
        if (!is_null($row_total) && !is_string($row_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($row_total)), __LINE__);
        }
        $this->row_total = $row_total;
        return $this;
    }
    /**
     * Get base_row_total value
     * @return string|null
     */
    public function getBase_row_total()
    {
        return $this->base_row_total;
    }
    /**
     * Set base_row_total value
     * @param string $base_row_total
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_row_total($base_row_total = null)
    {
        // validation for constraint: string
        if (!is_null($base_row_total) && !is_string($base_row_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_row_total)), __LINE__);
        }
        $this->base_row_total = $base_row_total;
        return $this;
    }
    /**
     * Get row_invoiced value
     * @return string|null
     */
    public function getRow_invoiced()
    {
        return $this->row_invoiced;
    }
    /**
     * Set row_invoiced value
     * @param string $row_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setRow_invoiced($row_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($row_invoiced) && !is_string($row_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($row_invoiced)), __LINE__);
        }
        $this->row_invoiced = $row_invoiced;
        return $this;
    }
    /**
     * Get base_row_invoiced value
     * @return string|null
     */
    public function getBase_row_invoiced()
    {
        return $this->base_row_invoiced;
    }
    /**
     * Set base_row_invoiced value
     * @param string $base_row_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_row_invoiced($base_row_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($base_row_invoiced) && !is_string($base_row_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_row_invoiced)), __LINE__);
        }
        $this->base_row_invoiced = $base_row_invoiced;
        return $this;
    }
    /**
     * Get row_weight value
     * @return string|null
     */
    public function getRow_weight()
    {
        return $this->row_weight;
    }
    /**
     * Set row_weight value
     * @param string $row_weight
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setRow_weight($row_weight = null)
    {
        // validation for constraint: string
        if (!is_null($row_weight) && !is_string($row_weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($row_weight)), __LINE__);
        }
        $this->row_weight = $row_weight;
        return $this;
    }
    /**
     * Get gift_message_id value
     * @return string|null
     */
    public function getGift_message_id()
    {
        return $this->gift_message_id;
    }
    /**
     * Set gift_message_id value
     * @param string $gift_message_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setGift_message_id($gift_message_id = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message_id) && !is_string($gift_message_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message_id)), __LINE__);
        }
        $this->gift_message_id = $gift_message_id;
        return $this;
    }
    /**
     * Get gift_message value
     * @return string|null
     */
    public function getGift_message()
    {
        return $this->gift_message;
    }
    /**
     * Set gift_message value
     * @param string $gift_message
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setGift_message($gift_message = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message) && !is_string($gift_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message)), __LINE__);
        }
        $this->gift_message = $gift_message;
        return $this;
    }
    /**
     * Get gift_message_available value
     * @return string|null
     */
    public function getGift_message_available()
    {
        return $this->gift_message_available;
    }
    /**
     * Set gift_message_available value
     * @param string $gift_message_available
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setGift_message_available($gift_message_available = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message_available) && !is_string($gift_message_available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message_available)), __LINE__);
        }
        $this->gift_message_available = $gift_message_available;
        return $this;
    }
    /**
     * Get base_tax_before_discount value
     * @return string|null
     */
    public function getBase_tax_before_discount()
    {
        return $this->base_tax_before_discount;
    }
    /**
     * Set base_tax_before_discount value
     * @param string $base_tax_before_discount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_tax_before_discount($base_tax_before_discount = null)
    {
        // validation for constraint: string
        if (!is_null($base_tax_before_discount) && !is_string($base_tax_before_discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_tax_before_discount)), __LINE__);
        }
        $this->base_tax_before_discount = $base_tax_before_discount;
        return $this;
    }
    /**
     * Get tax_before_discount value
     * @return string|null
     */
    public function getTax_before_discount()
    {
        return $this->tax_before_discount;
    }
    /**
     * Set tax_before_discount value
     * @param string $tax_before_discount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setTax_before_discount($tax_before_discount = null)
    {
        // validation for constraint: string
        if (!is_null($tax_before_discount) && !is_string($tax_before_discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_before_discount)), __LINE__);
        }
        $this->tax_before_discount = $tax_before_discount;
        return $this;
    }
    /**
     * Get weee_tax_applied value
     * @return string|null
     */
    public function getWeee_tax_applied()
    {
        return $this->weee_tax_applied;
    }
    /**
     * Set weee_tax_applied value
     * @param string $weee_tax_applied
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setWeee_tax_applied($weee_tax_applied = null)
    {
        // validation for constraint: string
        if (!is_null($weee_tax_applied) && !is_string($weee_tax_applied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weee_tax_applied)), __LINE__);
        }
        $this->weee_tax_applied = $weee_tax_applied;
        return $this;
    }
    /**
     * Get weee_tax_applied_amount value
     * @return string|null
     */
    public function getWeee_tax_applied_amount()
    {
        return $this->weee_tax_applied_amount;
    }
    /**
     * Set weee_tax_applied_amount value
     * @param string $weee_tax_applied_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setWeee_tax_applied_amount($weee_tax_applied_amount = null)
    {
        // validation for constraint: string
        if (!is_null($weee_tax_applied_amount) && !is_string($weee_tax_applied_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weee_tax_applied_amount)), __LINE__);
        }
        $this->weee_tax_applied_amount = $weee_tax_applied_amount;
        return $this;
    }
    /**
     * Get weee_tax_applied_row_amount value
     * @return string|null
     */
    public function getWeee_tax_applied_row_amount()
    {
        return $this->weee_tax_applied_row_amount;
    }
    /**
     * Set weee_tax_applied_row_amount value
     * @param string $weee_tax_applied_row_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setWeee_tax_applied_row_amount($weee_tax_applied_row_amount = null)
    {
        // validation for constraint: string
        if (!is_null($weee_tax_applied_row_amount) && !is_string($weee_tax_applied_row_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weee_tax_applied_row_amount)), __LINE__);
        }
        $this->weee_tax_applied_row_amount = $weee_tax_applied_row_amount;
        return $this;
    }
    /**
     * Get base_weee_tax_applied_amount value
     * @return string|null
     */
    public function getBase_weee_tax_applied_amount()
    {
        return $this->base_weee_tax_applied_amount;
    }
    /**
     * Set base_weee_tax_applied_amount value
     * @param string $base_weee_tax_applied_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_weee_tax_applied_amount($base_weee_tax_applied_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_weee_tax_applied_amount) && !is_string($base_weee_tax_applied_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_weee_tax_applied_amount)), __LINE__);
        }
        $this->base_weee_tax_applied_amount = $base_weee_tax_applied_amount;
        return $this;
    }
    /**
     * Get base_weee_tax_applied_row_amount value
     * @return string|null
     */
    public function getBase_weee_tax_applied_row_amount()
    {
        return $this->base_weee_tax_applied_row_amount;
    }
    /**
     * Set base_weee_tax_applied_row_amount value
     * @param string $base_weee_tax_applied_row_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_weee_tax_applied_row_amount($base_weee_tax_applied_row_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_weee_tax_applied_row_amount) && !is_string($base_weee_tax_applied_row_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_weee_tax_applied_row_amount)), __LINE__);
        }
        $this->base_weee_tax_applied_row_amount = $base_weee_tax_applied_row_amount;
        return $this;
    }
    /**
     * Get weee_tax_disposition value
     * @return string|null
     */
    public function getWeee_tax_disposition()
    {
        return $this->weee_tax_disposition;
    }
    /**
     * Set weee_tax_disposition value
     * @param string $weee_tax_disposition
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setWeee_tax_disposition($weee_tax_disposition = null)
    {
        // validation for constraint: string
        if (!is_null($weee_tax_disposition) && !is_string($weee_tax_disposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weee_tax_disposition)), __LINE__);
        }
        $this->weee_tax_disposition = $weee_tax_disposition;
        return $this;
    }
    /**
     * Get weee_tax_row_disposition value
     * @return string|null
     */
    public function getWeee_tax_row_disposition()
    {
        return $this->weee_tax_row_disposition;
    }
    /**
     * Set weee_tax_row_disposition value
     * @param string $weee_tax_row_disposition
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setWeee_tax_row_disposition($weee_tax_row_disposition = null)
    {
        // validation for constraint: string
        if (!is_null($weee_tax_row_disposition) && !is_string($weee_tax_row_disposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weee_tax_row_disposition)), __LINE__);
        }
        $this->weee_tax_row_disposition = $weee_tax_row_disposition;
        return $this;
    }
    /**
     * Get base_weee_tax_disposition value
     * @return string|null
     */
    public function getBase_weee_tax_disposition()
    {
        return $this->base_weee_tax_disposition;
    }
    /**
     * Set base_weee_tax_disposition value
     * @param string $base_weee_tax_disposition
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_weee_tax_disposition($base_weee_tax_disposition = null)
    {
        // validation for constraint: string
        if (!is_null($base_weee_tax_disposition) && !is_string($base_weee_tax_disposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_weee_tax_disposition)), __LINE__);
        }
        $this->base_weee_tax_disposition = $base_weee_tax_disposition;
        return $this;
    }
    /**
     * Get base_weee_tax_row_disposition value
     * @return string|null
     */
    public function getBase_weee_tax_row_disposition()
    {
        return $this->base_weee_tax_row_disposition;
    }
    /**
     * Set base_weee_tax_row_disposition value
     * @param string $base_weee_tax_row_disposition
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public function setBase_weee_tax_row_disposition($base_weee_tax_row_disposition = null)
    {
        // validation for constraint: string
        if (!is_null($base_weee_tax_row_disposition) && !is_string($base_weee_tax_row_disposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_weee_tax_row_disposition)), __LINE__);
        }
        $this->base_weee_tax_row_disposition = $base_weee_tax_row_disposition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderItemEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
