<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderInvoiceAddCommentRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderInvoiceAddCommentRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The invoiceIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoiceIncrementId;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The includeComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $includeComment;
    /**
     * Constructor method for salesOrderInvoiceAddCommentRequestParam
     * @uses SalesOrderInvoiceAddCommentRequestParam::setSessionId()
     * @uses SalesOrderInvoiceAddCommentRequestParam::setInvoiceIncrementId()
     * @uses SalesOrderInvoiceAddCommentRequestParam::setComment()
     * @uses SalesOrderInvoiceAddCommentRequestParam::setEmail()
     * @uses SalesOrderInvoiceAddCommentRequestParam::setIncludeComment()
     * @param string $sessionId
     * @param string $invoiceIncrementId
     * @param string $comment
     * @param string $email
     * @param string $includeComment
     */
    public function __construct($sessionId = null, $invoiceIncrementId = null, $comment = null, $email = null, $includeComment = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setInvoiceIncrementId($invoiceIncrementId)
            ->setComment($comment)
            ->setEmail($email)
            ->setIncludeComment($includeComment);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get invoiceIncrementId value
     * @return string
     */
    public function getInvoiceIncrementId()
    {
        return $this->invoiceIncrementId;
    }
    /**
     * Set invoiceIncrementId value
     * @param string $invoiceIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam
     */
    public function setInvoiceIncrementId($invoiceIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceIncrementId) && !is_string($invoiceIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceIncrementId)), __LINE__);
        }
        $this->invoiceIncrementId = $invoiceIncrementId;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get includeComment value
     * @return string|null
     */
    public function getIncludeComment()
    {
        return $this->includeComment;
    }
    /**
     * Set includeComment value
     * @param string $includeComment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam
     */
    public function setIncludeComment($includeComment = null)
    {
        // validation for constraint: string
        if (!is_null($includeComment) && !is_string($includeComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includeComment)), __LINE__);
        }
        $this->includeComment = $includeComment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
