<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderEntity StructType
 * @subpackage Structs
 */
class SalesOrderEntity extends AbstractStructBase
{
    /**
     * The increment_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $increment_id;
    /**
     * The parent_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parent_id;
    /**
     * The store_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_id;
    /**
     * The created_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $created_at;
    /**
     * The updated_at
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updated_at;
    /**
     * The is_active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_active;
    /**
     * The customer_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_id;
    /**
     * The tax_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax_amount;
    /**
     * The shipping_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_amount;
    /**
     * The discount_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discount_amount;
    /**
     * The subtotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subtotal;
    /**
     * The grand_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $grand_total;
    /**
     * The total_paid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_paid;
    /**
     * The total_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_refunded;
    /**
     * The total_qty_ordered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_qty_ordered;
    /**
     * The total_canceled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_canceled;
    /**
     * The total_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_invoiced;
    /**
     * The total_online_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_online_refunded;
    /**
     * The total_offline_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $total_offline_refunded;
    /**
     * The base_tax_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_tax_amount;
    /**
     * The base_shipping_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_shipping_amount;
    /**
     * The base_discount_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_discount_amount;
    /**
     * The base_subtotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_subtotal;
    /**
     * The base_grand_total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_grand_total;
    /**
     * The base_total_paid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_total_paid;
    /**
     * The base_total_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_total_refunded;
    /**
     * The base_total_qty_ordered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_total_qty_ordered;
    /**
     * The base_total_canceled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_total_canceled;
    /**
     * The base_total_invoiced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_total_invoiced;
    /**
     * The base_total_online_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_total_online_refunded;
    /**
     * The base_total_offline_refunded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_total_offline_refunded;
    /**
     * The billing_address_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billing_address_id;
    /**
     * The billing_firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billing_firstname;
    /**
     * The billing_lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billing_lastname;
    /**
     * The shipping_address_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_address_id;
    /**
     * The shipping_firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_firstname;
    /**
     * The shipping_lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_lastname;
    /**
     * The billing_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billing_name;
    /**
     * The shipping_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_name;
    /**
     * The store_to_base_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_to_base_rate;
    /**
     * The store_to_order_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_to_order_rate;
    /**
     * The base_to_global_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_to_global_rate;
    /**
     * The base_to_order_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_to_order_rate;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weight;
    /**
     * The store_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_name;
    /**
     * The remote_ip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $remote_ip;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The applied_rule_ids
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applied_rule_ids;
    /**
     * The global_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $global_currency_code;
    /**
     * The base_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base_currency_code;
    /**
     * The store_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $store_currency_code;
    /**
     * The order_currency_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_currency_code;
    /**
     * The shipping_method
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_method;
    /**
     * The shipping_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipping_description;
    /**
     * The customer_email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_email;
    /**
     * The customer_firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_firstname;
    /**
     * The customer_lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_lastname;
    /**
     * The quote_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quote_id;
    /**
     * The is_virtual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_virtual;
    /**
     * The customer_group_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_group_id;
    /**
     * The customer_note_notify
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_note_notify;
    /**
     * The customer_is_guest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_is_guest;
    /**
     * The email_sent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email_sent;
    /**
     * The order_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_id;
    /**
     * The gift_message_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message_id;
    /**
     * The gift_message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gift_message;
    /**
     * The shipping_address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity
     */
    public $shipping_address;
    /**
     * The billing_address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity
     */
    public $billing_address;
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\SalesOrderItemEntityArray
     */
    public $items;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\SalesOrderPaymentEntity
     */
    public $payment;
    /**
     * The status_history
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\SalesOrderStatusHistoryEntityArray
     */
    public $status_history;
    /**
     * Constructor method for salesOrderEntity
     * @uses SalesOrderEntity::setIncrement_id()
     * @uses SalesOrderEntity::setParent_id()
     * @uses SalesOrderEntity::setStore_id()
     * @uses SalesOrderEntity::setCreated_at()
     * @uses SalesOrderEntity::setUpdated_at()
     * @uses SalesOrderEntity::setIs_active()
     * @uses SalesOrderEntity::setCustomer_id()
     * @uses SalesOrderEntity::setTax_amount()
     * @uses SalesOrderEntity::setShipping_amount()
     * @uses SalesOrderEntity::setDiscount_amount()
     * @uses SalesOrderEntity::setSubtotal()
     * @uses SalesOrderEntity::setGrand_total()
     * @uses SalesOrderEntity::setTotal_paid()
     * @uses SalesOrderEntity::setTotal_refunded()
     * @uses SalesOrderEntity::setTotal_qty_ordered()
     * @uses SalesOrderEntity::setTotal_canceled()
     * @uses SalesOrderEntity::setTotal_invoiced()
     * @uses SalesOrderEntity::setTotal_online_refunded()
     * @uses SalesOrderEntity::setTotal_offline_refunded()
     * @uses SalesOrderEntity::setBase_tax_amount()
     * @uses SalesOrderEntity::setBase_shipping_amount()
     * @uses SalesOrderEntity::setBase_discount_amount()
     * @uses SalesOrderEntity::setBase_subtotal()
     * @uses SalesOrderEntity::setBase_grand_total()
     * @uses SalesOrderEntity::setBase_total_paid()
     * @uses SalesOrderEntity::setBase_total_refunded()
     * @uses SalesOrderEntity::setBase_total_qty_ordered()
     * @uses SalesOrderEntity::setBase_total_canceled()
     * @uses SalesOrderEntity::setBase_total_invoiced()
     * @uses SalesOrderEntity::setBase_total_online_refunded()
     * @uses SalesOrderEntity::setBase_total_offline_refunded()
     * @uses SalesOrderEntity::setBilling_address_id()
     * @uses SalesOrderEntity::setBilling_firstname()
     * @uses SalesOrderEntity::setBilling_lastname()
     * @uses SalesOrderEntity::setShipping_address_id()
     * @uses SalesOrderEntity::setShipping_firstname()
     * @uses SalesOrderEntity::setShipping_lastname()
     * @uses SalesOrderEntity::setBilling_name()
     * @uses SalesOrderEntity::setShipping_name()
     * @uses SalesOrderEntity::setStore_to_base_rate()
     * @uses SalesOrderEntity::setStore_to_order_rate()
     * @uses SalesOrderEntity::setBase_to_global_rate()
     * @uses SalesOrderEntity::setBase_to_order_rate()
     * @uses SalesOrderEntity::setWeight()
     * @uses SalesOrderEntity::setStore_name()
     * @uses SalesOrderEntity::setRemote_ip()
     * @uses SalesOrderEntity::setStatus()
     * @uses SalesOrderEntity::setState()
     * @uses SalesOrderEntity::setApplied_rule_ids()
     * @uses SalesOrderEntity::setGlobal_currency_code()
     * @uses SalesOrderEntity::setBase_currency_code()
     * @uses SalesOrderEntity::setStore_currency_code()
     * @uses SalesOrderEntity::setOrder_currency_code()
     * @uses SalesOrderEntity::setShipping_method()
     * @uses SalesOrderEntity::setShipping_description()
     * @uses SalesOrderEntity::setCustomer_email()
     * @uses SalesOrderEntity::setCustomer_firstname()
     * @uses SalesOrderEntity::setCustomer_lastname()
     * @uses SalesOrderEntity::setQuote_id()
     * @uses SalesOrderEntity::setIs_virtual()
     * @uses SalesOrderEntity::setCustomer_group_id()
     * @uses SalesOrderEntity::setCustomer_note_notify()
     * @uses SalesOrderEntity::setCustomer_is_guest()
     * @uses SalesOrderEntity::setEmail_sent()
     * @uses SalesOrderEntity::setOrder_id()
     * @uses SalesOrderEntity::setGift_message_id()
     * @uses SalesOrderEntity::setGift_message()
     * @uses SalesOrderEntity::setShipping_address()
     * @uses SalesOrderEntity::setBilling_address()
     * @uses SalesOrderEntity::setItems()
     * @uses SalesOrderEntity::setPayment()
     * @uses SalesOrderEntity::setStatus_history()
     * @param string $increment_id
     * @param string $parent_id
     * @param string $store_id
     * @param string $created_at
     * @param string $updated_at
     * @param string $is_active
     * @param string $customer_id
     * @param string $tax_amount
     * @param string $shipping_amount
     * @param string $discount_amount
     * @param string $subtotal
     * @param string $grand_total
     * @param string $total_paid
     * @param string $total_refunded
     * @param string $total_qty_ordered
     * @param string $total_canceled
     * @param string $total_invoiced
     * @param string $total_online_refunded
     * @param string $total_offline_refunded
     * @param string $base_tax_amount
     * @param string $base_shipping_amount
     * @param string $base_discount_amount
     * @param string $base_subtotal
     * @param string $base_grand_total
     * @param string $base_total_paid
     * @param string $base_total_refunded
     * @param string $base_total_qty_ordered
     * @param string $base_total_canceled
     * @param string $base_total_invoiced
     * @param string $base_total_online_refunded
     * @param string $base_total_offline_refunded
     * @param string $billing_address_id
     * @param string $billing_firstname
     * @param string $billing_lastname
     * @param string $shipping_address_id
     * @param string $shipping_firstname
     * @param string $shipping_lastname
     * @param string $billing_name
     * @param string $shipping_name
     * @param string $store_to_base_rate
     * @param string $store_to_order_rate
     * @param string $base_to_global_rate
     * @param string $base_to_order_rate
     * @param string $weight
     * @param string $store_name
     * @param string $remote_ip
     * @param string $status
     * @param string $state
     * @param string $applied_rule_ids
     * @param string $global_currency_code
     * @param string $base_currency_code
     * @param string $store_currency_code
     * @param string $order_currency_code
     * @param string $shipping_method
     * @param string $shipping_description
     * @param string $customer_email
     * @param string $customer_firstname
     * @param string $customer_lastname
     * @param string $quote_id
     * @param string $is_virtual
     * @param string $customer_group_id
     * @param string $customer_note_notify
     * @param string $customer_is_guest
     * @param string $email_sent
     * @param string $order_id
     * @param string $gift_message_id
     * @param string $gift_message
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $shipping_address
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $billing_address
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderItemEntityArray $items
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderPaymentEntity $payment
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderStatusHistoryEntityArray $status_history
     */
    public function __construct($increment_id = null, $parent_id = null, $store_id = null, $created_at = null, $updated_at = null, $is_active = null, $customer_id = null, $tax_amount = null, $shipping_amount = null, $discount_amount = null, $subtotal = null, $grand_total = null, $total_paid = null, $total_refunded = null, $total_qty_ordered = null, $total_canceled = null, $total_invoiced = null, $total_online_refunded = null, $total_offline_refunded = null, $base_tax_amount = null, $base_shipping_amount = null, $base_discount_amount = null, $base_subtotal = null, $base_grand_total = null, $base_total_paid = null, $base_total_refunded = null, $base_total_qty_ordered = null, $base_total_canceled = null, $base_total_invoiced = null, $base_total_online_refunded = null, $base_total_offline_refunded = null, $billing_address_id = null, $billing_firstname = null, $billing_lastname = null, $shipping_address_id = null, $shipping_firstname = null, $shipping_lastname = null, $billing_name = null, $shipping_name = null, $store_to_base_rate = null, $store_to_order_rate = null, $base_to_global_rate = null, $base_to_order_rate = null, $weight = null, $store_name = null, $remote_ip = null, $status = null, $state = null, $applied_rule_ids = null, $global_currency_code = null, $base_currency_code = null, $store_currency_code = null, $order_currency_code = null, $shipping_method = null, $shipping_description = null, $customer_email = null, $customer_firstname = null, $customer_lastname = null, $quote_id = null, $is_virtual = null, $customer_group_id = null, $customer_note_notify = null, $customer_is_guest = null, $email_sent = null, $order_id = null, $gift_message_id = null, $gift_message = null, \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $shipping_address = null, \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $billing_address = null, \App\Api\Client\Magento\Type\ArrayType\SalesOrderItemEntityArray $items = null, \App\Api\Client\Magento\Type\StructType\SalesOrderPaymentEntity $payment = null, \App\Api\Client\Magento\Type\ArrayType\SalesOrderStatusHistoryEntityArray $status_history = null)
    {
        $this
            ->setIncrement_id($increment_id)
            ->setParent_id($parent_id)
            ->setStore_id($store_id)
            ->setCreated_at($created_at)
            ->setUpdated_at($updated_at)
            ->setIs_active($is_active)
            ->setCustomer_id($customer_id)
            ->setTax_amount($tax_amount)
            ->setShipping_amount($shipping_amount)
            ->setDiscount_amount($discount_amount)
            ->setSubtotal($subtotal)
            ->setGrand_total($grand_total)
            ->setTotal_paid($total_paid)
            ->setTotal_refunded($total_refunded)
            ->setTotal_qty_ordered($total_qty_ordered)
            ->setTotal_canceled($total_canceled)
            ->setTotal_invoiced($total_invoiced)
            ->setTotal_online_refunded($total_online_refunded)
            ->setTotal_offline_refunded($total_offline_refunded)
            ->setBase_tax_amount($base_tax_amount)
            ->setBase_shipping_amount($base_shipping_amount)
            ->setBase_discount_amount($base_discount_amount)
            ->setBase_subtotal($base_subtotal)
            ->setBase_grand_total($base_grand_total)
            ->setBase_total_paid($base_total_paid)
            ->setBase_total_refunded($base_total_refunded)
            ->setBase_total_qty_ordered($base_total_qty_ordered)
            ->setBase_total_canceled($base_total_canceled)
            ->setBase_total_invoiced($base_total_invoiced)
            ->setBase_total_online_refunded($base_total_online_refunded)
            ->setBase_total_offline_refunded($base_total_offline_refunded)
            ->setBilling_address_id($billing_address_id)
            ->setBilling_firstname($billing_firstname)
            ->setBilling_lastname($billing_lastname)
            ->setShipping_address_id($shipping_address_id)
            ->setShipping_firstname($shipping_firstname)
            ->setShipping_lastname($shipping_lastname)
            ->setBilling_name($billing_name)
            ->setShipping_name($shipping_name)
            ->setStore_to_base_rate($store_to_base_rate)
            ->setStore_to_order_rate($store_to_order_rate)
            ->setBase_to_global_rate($base_to_global_rate)
            ->setBase_to_order_rate($base_to_order_rate)
            ->setWeight($weight)
            ->setStore_name($store_name)
            ->setRemote_ip($remote_ip)
            ->setStatus($status)
            ->setState($state)
            ->setApplied_rule_ids($applied_rule_ids)
            ->setGlobal_currency_code($global_currency_code)
            ->setBase_currency_code($base_currency_code)
            ->setStore_currency_code($store_currency_code)
            ->setOrder_currency_code($order_currency_code)
            ->setShipping_method($shipping_method)
            ->setShipping_description($shipping_description)
            ->setCustomer_email($customer_email)
            ->setCustomer_firstname($customer_firstname)
            ->setCustomer_lastname($customer_lastname)
            ->setQuote_id($quote_id)
            ->setIs_virtual($is_virtual)
            ->setCustomer_group_id($customer_group_id)
            ->setCustomer_note_notify($customer_note_notify)
            ->setCustomer_is_guest($customer_is_guest)
            ->setEmail_sent($email_sent)
            ->setOrder_id($order_id)
            ->setGift_message_id($gift_message_id)
            ->setGift_message($gift_message)
            ->setShipping_address($shipping_address)
            ->setBilling_address($billing_address)
            ->setItems($items)
            ->setPayment($payment)
            ->setStatus_history($status_history);
    }
    /**
     * Get increment_id value
     * @return string|null
     */
    public function getIncrement_id()
    {
        return $this->increment_id;
    }
    /**
     * Set increment_id value
     * @param string $increment_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setIncrement_id($increment_id = null)
    {
        // validation for constraint: string
        if (!is_null($increment_id) && !is_string($increment_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($increment_id)), __LINE__);
        }
        $this->increment_id = $increment_id;
        return $this;
    }
    /**
     * Get parent_id value
     * @return string|null
     */
    public function getParent_id()
    {
        return $this->parent_id;
    }
    /**
     * Set parent_id value
     * @param string $parent_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setParent_id($parent_id = null)
    {
        // validation for constraint: string
        if (!is_null($parent_id) && !is_string($parent_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent_id)), __LINE__);
        }
        $this->parent_id = $parent_id;
        return $this;
    }
    /**
     * Get store_id value
     * @return string|null
     */
    public function getStore_id()
    {
        return $this->store_id;
    }
    /**
     * Set store_id value
     * @param string $store_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setStore_id($store_id = null)
    {
        // validation for constraint: string
        if (!is_null($store_id) && !is_string($store_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_id)), __LINE__);
        }
        $this->store_id = $store_id;
        return $this;
    }
    /**
     * Get created_at value
     * @return string|null
     */
    public function getCreated_at()
    {
        return $this->created_at;
    }
    /**
     * Set created_at value
     * @param string $created_at
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCreated_at($created_at = null)
    {
        // validation for constraint: string
        if (!is_null($created_at) && !is_string($created_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created_at)), __LINE__);
        }
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Get updated_at value
     * @return string|null
     */
    public function getUpdated_at()
    {
        return $this->updated_at;
    }
    /**
     * Set updated_at value
     * @param string $updated_at
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setUpdated_at($updated_at = null)
    {
        // validation for constraint: string
        if (!is_null($updated_at) && !is_string($updated_at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updated_at)), __LINE__);
        }
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Get is_active value
     * @return string|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param string $is_active
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: string
        if (!is_null($is_active) && !is_string($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get customer_id value
     * @return string|null
     */
    public function getCustomer_id()
    {
        return $this->customer_id;
    }
    /**
     * Set customer_id value
     * @param string $customer_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCustomer_id($customer_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_id) && !is_string($customer_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_id)), __LINE__);
        }
        $this->customer_id = $customer_id;
        return $this;
    }
    /**
     * Get tax_amount value
     * @return string|null
     */
    public function getTax_amount()
    {
        return $this->tax_amount;
    }
    /**
     * Set tax_amount value
     * @param string $tax_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTax_amount($tax_amount = null)
    {
        // validation for constraint: string
        if (!is_null($tax_amount) && !is_string($tax_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_amount)), __LINE__);
        }
        $this->tax_amount = $tax_amount;
        return $this;
    }
    /**
     * Get shipping_amount value
     * @return string|null
     */
    public function getShipping_amount()
    {
        return $this->shipping_amount;
    }
    /**
     * Set shipping_amount value
     * @param string $shipping_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_amount($shipping_amount = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_amount) && !is_string($shipping_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_amount)), __LINE__);
        }
        $this->shipping_amount = $shipping_amount;
        return $this;
    }
    /**
     * Get discount_amount value
     * @return string|null
     */
    public function getDiscount_amount()
    {
        return $this->discount_amount;
    }
    /**
     * Set discount_amount value
     * @param string $discount_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setDiscount_amount($discount_amount = null)
    {
        // validation for constraint: string
        if (!is_null($discount_amount) && !is_string($discount_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discount_amount)), __LINE__);
        }
        $this->discount_amount = $discount_amount;
        return $this;
    }
    /**
     * Get subtotal value
     * @return string|null
     */
    public function getSubtotal()
    {
        return $this->subtotal;
    }
    /**
     * Set subtotal value
     * @param string $subtotal
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setSubtotal($subtotal = null)
    {
        // validation for constraint: string
        if (!is_null($subtotal) && !is_string($subtotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subtotal)), __LINE__);
        }
        $this->subtotal = $subtotal;
        return $this;
    }
    /**
     * Get grand_total value
     * @return string|null
     */
    public function getGrand_total()
    {
        return $this->grand_total;
    }
    /**
     * Set grand_total value
     * @param string $grand_total
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setGrand_total($grand_total = null)
    {
        // validation for constraint: string
        if (!is_null($grand_total) && !is_string($grand_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grand_total)), __LINE__);
        }
        $this->grand_total = $grand_total;
        return $this;
    }
    /**
     * Get total_paid value
     * @return string|null
     */
    public function getTotal_paid()
    {
        return $this->total_paid;
    }
    /**
     * Set total_paid value
     * @param string $total_paid
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTotal_paid($total_paid = null)
    {
        // validation for constraint: string
        if (!is_null($total_paid) && !is_string($total_paid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_paid)), __LINE__);
        }
        $this->total_paid = $total_paid;
        return $this;
    }
    /**
     * Get total_refunded value
     * @return string|null
     */
    public function getTotal_refunded()
    {
        return $this->total_refunded;
    }
    /**
     * Set total_refunded value
     * @param string $total_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTotal_refunded($total_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($total_refunded) && !is_string($total_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_refunded)), __LINE__);
        }
        $this->total_refunded = $total_refunded;
        return $this;
    }
    /**
     * Get total_qty_ordered value
     * @return string|null
     */
    public function getTotal_qty_ordered()
    {
        return $this->total_qty_ordered;
    }
    /**
     * Set total_qty_ordered value
     * @param string $total_qty_ordered
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTotal_qty_ordered($total_qty_ordered = null)
    {
        // validation for constraint: string
        if (!is_null($total_qty_ordered) && !is_string($total_qty_ordered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_qty_ordered)), __LINE__);
        }
        $this->total_qty_ordered = $total_qty_ordered;
        return $this;
    }
    /**
     * Get total_canceled value
     * @return string|null
     */
    public function getTotal_canceled()
    {
        return $this->total_canceled;
    }
    /**
     * Set total_canceled value
     * @param string $total_canceled
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTotal_canceled($total_canceled = null)
    {
        // validation for constraint: string
        if (!is_null($total_canceled) && !is_string($total_canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_canceled)), __LINE__);
        }
        $this->total_canceled = $total_canceled;
        return $this;
    }
    /**
     * Get total_invoiced value
     * @return string|null
     */
    public function getTotal_invoiced()
    {
        return $this->total_invoiced;
    }
    /**
     * Set total_invoiced value
     * @param string $total_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTotal_invoiced($total_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($total_invoiced) && !is_string($total_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_invoiced)), __LINE__);
        }
        $this->total_invoiced = $total_invoiced;
        return $this;
    }
    /**
     * Get total_online_refunded value
     * @return string|null
     */
    public function getTotal_online_refunded()
    {
        return $this->total_online_refunded;
    }
    /**
     * Set total_online_refunded value
     * @param string $total_online_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTotal_online_refunded($total_online_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($total_online_refunded) && !is_string($total_online_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_online_refunded)), __LINE__);
        }
        $this->total_online_refunded = $total_online_refunded;
        return $this;
    }
    /**
     * Get total_offline_refunded value
     * @return string|null
     */
    public function getTotal_offline_refunded()
    {
        return $this->total_offline_refunded;
    }
    /**
     * Set total_offline_refunded value
     * @param string $total_offline_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setTotal_offline_refunded($total_offline_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($total_offline_refunded) && !is_string($total_offline_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($total_offline_refunded)), __LINE__);
        }
        $this->total_offline_refunded = $total_offline_refunded;
        return $this;
    }
    /**
     * Get base_tax_amount value
     * @return string|null
     */
    public function getBase_tax_amount()
    {
        return $this->base_tax_amount;
    }
    /**
     * Set base_tax_amount value
     * @param string $base_tax_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_tax_amount($base_tax_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_tax_amount) && !is_string($base_tax_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_tax_amount)), __LINE__);
        }
        $this->base_tax_amount = $base_tax_amount;
        return $this;
    }
    /**
     * Get base_shipping_amount value
     * @return string|null
     */
    public function getBase_shipping_amount()
    {
        return $this->base_shipping_amount;
    }
    /**
     * Set base_shipping_amount value
     * @param string $base_shipping_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_shipping_amount($base_shipping_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_shipping_amount) && !is_string($base_shipping_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_shipping_amount)), __LINE__);
        }
        $this->base_shipping_amount = $base_shipping_amount;
        return $this;
    }
    /**
     * Get base_discount_amount value
     * @return string|null
     */
    public function getBase_discount_amount()
    {
        return $this->base_discount_amount;
    }
    /**
     * Set base_discount_amount value
     * @param string $base_discount_amount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_discount_amount($base_discount_amount = null)
    {
        // validation for constraint: string
        if (!is_null($base_discount_amount) && !is_string($base_discount_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_discount_amount)), __LINE__);
        }
        $this->base_discount_amount = $base_discount_amount;
        return $this;
    }
    /**
     * Get base_subtotal value
     * @return string|null
     */
    public function getBase_subtotal()
    {
        return $this->base_subtotal;
    }
    /**
     * Set base_subtotal value
     * @param string $base_subtotal
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_subtotal($base_subtotal = null)
    {
        // validation for constraint: string
        if (!is_null($base_subtotal) && !is_string($base_subtotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_subtotal)), __LINE__);
        }
        $this->base_subtotal = $base_subtotal;
        return $this;
    }
    /**
     * Get base_grand_total value
     * @return string|null
     */
    public function getBase_grand_total()
    {
        return $this->base_grand_total;
    }
    /**
     * Set base_grand_total value
     * @param string $base_grand_total
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_grand_total($base_grand_total = null)
    {
        // validation for constraint: string
        if (!is_null($base_grand_total) && !is_string($base_grand_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_grand_total)), __LINE__);
        }
        $this->base_grand_total = $base_grand_total;
        return $this;
    }
    /**
     * Get base_total_paid value
     * @return string|null
     */
    public function getBase_total_paid()
    {
        return $this->base_total_paid;
    }
    /**
     * Set base_total_paid value
     * @param string $base_total_paid
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_total_paid($base_total_paid = null)
    {
        // validation for constraint: string
        if (!is_null($base_total_paid) && !is_string($base_total_paid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_total_paid)), __LINE__);
        }
        $this->base_total_paid = $base_total_paid;
        return $this;
    }
    /**
     * Get base_total_refunded value
     * @return string|null
     */
    public function getBase_total_refunded()
    {
        return $this->base_total_refunded;
    }
    /**
     * Set base_total_refunded value
     * @param string $base_total_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_total_refunded($base_total_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($base_total_refunded) && !is_string($base_total_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_total_refunded)), __LINE__);
        }
        $this->base_total_refunded = $base_total_refunded;
        return $this;
    }
    /**
     * Get base_total_qty_ordered value
     * @return string|null
     */
    public function getBase_total_qty_ordered()
    {
        return $this->base_total_qty_ordered;
    }
    /**
     * Set base_total_qty_ordered value
     * @param string $base_total_qty_ordered
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_total_qty_ordered($base_total_qty_ordered = null)
    {
        // validation for constraint: string
        if (!is_null($base_total_qty_ordered) && !is_string($base_total_qty_ordered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_total_qty_ordered)), __LINE__);
        }
        $this->base_total_qty_ordered = $base_total_qty_ordered;
        return $this;
    }
    /**
     * Get base_total_canceled value
     * @return string|null
     */
    public function getBase_total_canceled()
    {
        return $this->base_total_canceled;
    }
    /**
     * Set base_total_canceled value
     * @param string $base_total_canceled
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_total_canceled($base_total_canceled = null)
    {
        // validation for constraint: string
        if (!is_null($base_total_canceled) && !is_string($base_total_canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_total_canceled)), __LINE__);
        }
        $this->base_total_canceled = $base_total_canceled;
        return $this;
    }
    /**
     * Get base_total_invoiced value
     * @return string|null
     */
    public function getBase_total_invoiced()
    {
        return $this->base_total_invoiced;
    }
    /**
     * Set base_total_invoiced value
     * @param string $base_total_invoiced
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_total_invoiced($base_total_invoiced = null)
    {
        // validation for constraint: string
        if (!is_null($base_total_invoiced) && !is_string($base_total_invoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_total_invoiced)), __LINE__);
        }
        $this->base_total_invoiced = $base_total_invoiced;
        return $this;
    }
    /**
     * Get base_total_online_refunded value
     * @return string|null
     */
    public function getBase_total_online_refunded()
    {
        return $this->base_total_online_refunded;
    }
    /**
     * Set base_total_online_refunded value
     * @param string $base_total_online_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_total_online_refunded($base_total_online_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($base_total_online_refunded) && !is_string($base_total_online_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_total_online_refunded)), __LINE__);
        }
        $this->base_total_online_refunded = $base_total_online_refunded;
        return $this;
    }
    /**
     * Get base_total_offline_refunded value
     * @return string|null
     */
    public function getBase_total_offline_refunded()
    {
        return $this->base_total_offline_refunded;
    }
    /**
     * Set base_total_offline_refunded value
     * @param string $base_total_offline_refunded
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_total_offline_refunded($base_total_offline_refunded = null)
    {
        // validation for constraint: string
        if (!is_null($base_total_offline_refunded) && !is_string($base_total_offline_refunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_total_offline_refunded)), __LINE__);
        }
        $this->base_total_offline_refunded = $base_total_offline_refunded;
        return $this;
    }
    /**
     * Get billing_address_id value
     * @return string|null
     */
    public function getBilling_address_id()
    {
        return $this->billing_address_id;
    }
    /**
     * Set billing_address_id value
     * @param string $billing_address_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBilling_address_id($billing_address_id = null)
    {
        // validation for constraint: string
        if (!is_null($billing_address_id) && !is_string($billing_address_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billing_address_id)), __LINE__);
        }
        $this->billing_address_id = $billing_address_id;
        return $this;
    }
    /**
     * Get billing_firstname value
     * @return string|null
     */
    public function getBilling_firstname()
    {
        return $this->billing_firstname;
    }
    /**
     * Set billing_firstname value
     * @param string $billing_firstname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBilling_firstname($billing_firstname = null)
    {
        // validation for constraint: string
        if (!is_null($billing_firstname) && !is_string($billing_firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billing_firstname)), __LINE__);
        }
        $this->billing_firstname = $billing_firstname;
        return $this;
    }
    /**
     * Get billing_lastname value
     * @return string|null
     */
    public function getBilling_lastname()
    {
        return $this->billing_lastname;
    }
    /**
     * Set billing_lastname value
     * @param string $billing_lastname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBilling_lastname($billing_lastname = null)
    {
        // validation for constraint: string
        if (!is_null($billing_lastname) && !is_string($billing_lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billing_lastname)), __LINE__);
        }
        $this->billing_lastname = $billing_lastname;
        return $this;
    }
    /**
     * Get shipping_address_id value
     * @return string|null
     */
    public function getShipping_address_id()
    {
        return $this->shipping_address_id;
    }
    /**
     * Set shipping_address_id value
     * @param string $shipping_address_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_address_id($shipping_address_id = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_address_id) && !is_string($shipping_address_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_address_id)), __LINE__);
        }
        $this->shipping_address_id = $shipping_address_id;
        return $this;
    }
    /**
     * Get shipping_firstname value
     * @return string|null
     */
    public function getShipping_firstname()
    {
        return $this->shipping_firstname;
    }
    /**
     * Set shipping_firstname value
     * @param string $shipping_firstname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_firstname($shipping_firstname = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_firstname) && !is_string($shipping_firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_firstname)), __LINE__);
        }
        $this->shipping_firstname = $shipping_firstname;
        return $this;
    }
    /**
     * Get shipping_lastname value
     * @return string|null
     */
    public function getShipping_lastname()
    {
        return $this->shipping_lastname;
    }
    /**
     * Set shipping_lastname value
     * @param string $shipping_lastname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_lastname($shipping_lastname = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_lastname) && !is_string($shipping_lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_lastname)), __LINE__);
        }
        $this->shipping_lastname = $shipping_lastname;
        return $this;
    }
    /**
     * Get billing_name value
     * @return string|null
     */
    public function getBilling_name()
    {
        return $this->billing_name;
    }
    /**
     * Set billing_name value
     * @param string $billing_name
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBilling_name($billing_name = null)
    {
        // validation for constraint: string
        if (!is_null($billing_name) && !is_string($billing_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billing_name)), __LINE__);
        }
        $this->billing_name = $billing_name;
        return $this;
    }
    /**
     * Get shipping_name value
     * @return string|null
     */
    public function getShipping_name()
    {
        return $this->shipping_name;
    }
    /**
     * Set shipping_name value
     * @param string $shipping_name
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_name($shipping_name = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_name) && !is_string($shipping_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_name)), __LINE__);
        }
        $this->shipping_name = $shipping_name;
        return $this;
    }
    /**
     * Get store_to_base_rate value
     * @return string|null
     */
    public function getStore_to_base_rate()
    {
        return $this->store_to_base_rate;
    }
    /**
     * Set store_to_base_rate value
     * @param string $store_to_base_rate
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setStore_to_base_rate($store_to_base_rate = null)
    {
        // validation for constraint: string
        if (!is_null($store_to_base_rate) && !is_string($store_to_base_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_to_base_rate)), __LINE__);
        }
        $this->store_to_base_rate = $store_to_base_rate;
        return $this;
    }
    /**
     * Get store_to_order_rate value
     * @return string|null
     */
    public function getStore_to_order_rate()
    {
        return $this->store_to_order_rate;
    }
    /**
     * Set store_to_order_rate value
     * @param string $store_to_order_rate
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setStore_to_order_rate($store_to_order_rate = null)
    {
        // validation for constraint: string
        if (!is_null($store_to_order_rate) && !is_string($store_to_order_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_to_order_rate)), __LINE__);
        }
        $this->store_to_order_rate = $store_to_order_rate;
        return $this;
    }
    /**
     * Get base_to_global_rate value
     * @return string|null
     */
    public function getBase_to_global_rate()
    {
        return $this->base_to_global_rate;
    }
    /**
     * Set base_to_global_rate value
     * @param string $base_to_global_rate
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_to_global_rate($base_to_global_rate = null)
    {
        // validation for constraint: string
        if (!is_null($base_to_global_rate) && !is_string($base_to_global_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_to_global_rate)), __LINE__);
        }
        $this->base_to_global_rate = $base_to_global_rate;
        return $this;
    }
    /**
     * Get base_to_order_rate value
     * @return string|null
     */
    public function getBase_to_order_rate()
    {
        return $this->base_to_order_rate;
    }
    /**
     * Set base_to_order_rate value
     * @param string $base_to_order_rate
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_to_order_rate($base_to_order_rate = null)
    {
        // validation for constraint: string
        if (!is_null($base_to_order_rate) && !is_string($base_to_order_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_to_order_rate)), __LINE__);
        }
        $this->base_to_order_rate = $base_to_order_rate;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get store_name value
     * @return string|null
     */
    public function getStore_name()
    {
        return $this->store_name;
    }
    /**
     * Set store_name value
     * @param string $store_name
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setStore_name($store_name = null)
    {
        // validation for constraint: string
        if (!is_null($store_name) && !is_string($store_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_name)), __LINE__);
        }
        $this->store_name = $store_name;
        return $this;
    }
    /**
     * Get remote_ip value
     * @return string|null
     */
    public function getRemote_ip()
    {
        return $this->remote_ip;
    }
    /**
     * Set remote_ip value
     * @param string $remote_ip
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setRemote_ip($remote_ip = null)
    {
        // validation for constraint: string
        if (!is_null($remote_ip) && !is_string($remote_ip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remote_ip)), __LINE__);
        }
        $this->remote_ip = $remote_ip;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get applied_rule_ids value
     * @return string|null
     */
    public function getApplied_rule_ids()
    {
        return $this->applied_rule_ids;
    }
    /**
     * Set applied_rule_ids value
     * @param string $applied_rule_ids
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setApplied_rule_ids($applied_rule_ids = null)
    {
        // validation for constraint: string
        if (!is_null($applied_rule_ids) && !is_string($applied_rule_ids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applied_rule_ids)), __LINE__);
        }
        $this->applied_rule_ids = $applied_rule_ids;
        return $this;
    }
    /**
     * Get global_currency_code value
     * @return string|null
     */
    public function getGlobal_currency_code()
    {
        return $this->global_currency_code;
    }
    /**
     * Set global_currency_code value
     * @param string $global_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setGlobal_currency_code($global_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($global_currency_code) && !is_string($global_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($global_currency_code)), __LINE__);
        }
        $this->global_currency_code = $global_currency_code;
        return $this;
    }
    /**
     * Get base_currency_code value
     * @return string|null
     */
    public function getBase_currency_code()
    {
        return $this->base_currency_code;
    }
    /**
     * Set base_currency_code value
     * @param string $base_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBase_currency_code($base_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($base_currency_code) && !is_string($base_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($base_currency_code)), __LINE__);
        }
        $this->base_currency_code = $base_currency_code;
        return $this;
    }
    /**
     * Get store_currency_code value
     * @return string|null
     */
    public function getStore_currency_code()
    {
        return $this->store_currency_code;
    }
    /**
     * Set store_currency_code value
     * @param string $store_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setStore_currency_code($store_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($store_currency_code) && !is_string($store_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store_currency_code)), __LINE__);
        }
        $this->store_currency_code = $store_currency_code;
        return $this;
    }
    /**
     * Get order_currency_code value
     * @return string|null
     */
    public function getOrder_currency_code()
    {
        return $this->order_currency_code;
    }
    /**
     * Set order_currency_code value
     * @param string $order_currency_code
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setOrder_currency_code($order_currency_code = null)
    {
        // validation for constraint: string
        if (!is_null($order_currency_code) && !is_string($order_currency_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_currency_code)), __LINE__);
        }
        $this->order_currency_code = $order_currency_code;
        return $this;
    }
    /**
     * Get shipping_method value
     * @return string|null
     */
    public function getShipping_method()
    {
        return $this->shipping_method;
    }
    /**
     * Set shipping_method value
     * @param string $shipping_method
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_method($shipping_method = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_method) && !is_string($shipping_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_method)), __LINE__);
        }
        $this->shipping_method = $shipping_method;
        return $this;
    }
    /**
     * Get shipping_description value
     * @return string|null
     */
    public function getShipping_description()
    {
        return $this->shipping_description;
    }
    /**
     * Set shipping_description value
     * @param string $shipping_description
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_description($shipping_description = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_description) && !is_string($shipping_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipping_description)), __LINE__);
        }
        $this->shipping_description = $shipping_description;
        return $this;
    }
    /**
     * Get customer_email value
     * @return string|null
     */
    public function getCustomer_email()
    {
        return $this->customer_email;
    }
    /**
     * Set customer_email value
     * @param string $customer_email
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCustomer_email($customer_email = null)
    {
        // validation for constraint: string
        if (!is_null($customer_email) && !is_string($customer_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_email)), __LINE__);
        }
        $this->customer_email = $customer_email;
        return $this;
    }
    /**
     * Get customer_firstname value
     * @return string|null
     */
    public function getCustomer_firstname()
    {
        return $this->customer_firstname;
    }
    /**
     * Set customer_firstname value
     * @param string $customer_firstname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCustomer_firstname($customer_firstname = null)
    {
        // validation for constraint: string
        if (!is_null($customer_firstname) && !is_string($customer_firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_firstname)), __LINE__);
        }
        $this->customer_firstname = $customer_firstname;
        return $this;
    }
    /**
     * Get customer_lastname value
     * @return string|null
     */
    public function getCustomer_lastname()
    {
        return $this->customer_lastname;
    }
    /**
     * Set customer_lastname value
     * @param string $customer_lastname
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCustomer_lastname($customer_lastname = null)
    {
        // validation for constraint: string
        if (!is_null($customer_lastname) && !is_string($customer_lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_lastname)), __LINE__);
        }
        $this->customer_lastname = $customer_lastname;
        return $this;
    }
    /**
     * Get quote_id value
     * @return string|null
     */
    public function getQuote_id()
    {
        return $this->quote_id;
    }
    /**
     * Set quote_id value
     * @param string $quote_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setQuote_id($quote_id = null)
    {
        // validation for constraint: string
        if (!is_null($quote_id) && !is_string($quote_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quote_id)), __LINE__);
        }
        $this->quote_id = $quote_id;
        return $this;
    }
    /**
     * Get is_virtual value
     * @return string|null
     */
    public function getIs_virtual()
    {
        return $this->is_virtual;
    }
    /**
     * Set is_virtual value
     * @param string $is_virtual
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setIs_virtual($is_virtual = null)
    {
        // validation for constraint: string
        if (!is_null($is_virtual) && !is_string($is_virtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_virtual)), __LINE__);
        }
        $this->is_virtual = $is_virtual;
        return $this;
    }
    /**
     * Get customer_group_id value
     * @return string|null
     */
    public function getCustomer_group_id()
    {
        return $this->customer_group_id;
    }
    /**
     * Set customer_group_id value
     * @param string $customer_group_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCustomer_group_id($customer_group_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_group_id) && !is_string($customer_group_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_group_id)), __LINE__);
        }
        $this->customer_group_id = $customer_group_id;
        return $this;
    }
    /**
     * Get customer_note_notify value
     * @return string|null
     */
    public function getCustomer_note_notify()
    {
        return $this->customer_note_notify;
    }
    /**
     * Set customer_note_notify value
     * @param string $customer_note_notify
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCustomer_note_notify($customer_note_notify = null)
    {
        // validation for constraint: string
        if (!is_null($customer_note_notify) && !is_string($customer_note_notify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_note_notify)), __LINE__);
        }
        $this->customer_note_notify = $customer_note_notify;
        return $this;
    }
    /**
     * Get customer_is_guest value
     * @return string|null
     */
    public function getCustomer_is_guest()
    {
        return $this->customer_is_guest;
    }
    /**
     * Set customer_is_guest value
     * @param string $customer_is_guest
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setCustomer_is_guest($customer_is_guest = null)
    {
        // validation for constraint: string
        if (!is_null($customer_is_guest) && !is_string($customer_is_guest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_is_guest)), __LINE__);
        }
        $this->customer_is_guest = $customer_is_guest;
        return $this;
    }
    /**
     * Get email_sent value
     * @return string|null
     */
    public function getEmail_sent()
    {
        return $this->email_sent;
    }
    /**
     * Set email_sent value
     * @param string $email_sent
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setEmail_sent($email_sent = null)
    {
        // validation for constraint: string
        if (!is_null($email_sent) && !is_string($email_sent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email_sent)), __LINE__);
        }
        $this->email_sent = $email_sent;
        return $this;
    }
    /**
     * Get order_id value
     * @return string|null
     */
    public function getOrder_id()
    {
        return $this->order_id;
    }
    /**
     * Set order_id value
     * @param string $order_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_id)), __LINE__);
        }
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Get gift_message_id value
     * @return string|null
     */
    public function getGift_message_id()
    {
        return $this->gift_message_id;
    }
    /**
     * Set gift_message_id value
     * @param string $gift_message_id
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setGift_message_id($gift_message_id = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message_id) && !is_string($gift_message_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message_id)), __LINE__);
        }
        $this->gift_message_id = $gift_message_id;
        return $this;
    }
    /**
     * Get gift_message value
     * @return string|null
     */
    public function getGift_message()
    {
        return $this->gift_message;
    }
    /**
     * Set gift_message value
     * @param string $gift_message
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setGift_message($gift_message = null)
    {
        // validation for constraint: string
        if (!is_null($gift_message) && !is_string($gift_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gift_message)), __LINE__);
        }
        $this->gift_message = $gift_message;
        return $this;
    }
    /**
     * Get shipping_address value
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity|null
     */
    public function getShipping_address()
    {
        return $this->shipping_address;
    }
    /**
     * Set shipping_address value
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $shipping_address
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setShipping_address(\App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $shipping_address = null)
    {
        $this->shipping_address = $shipping_address;
        return $this;
    }
    /**
     * Get billing_address value
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity|null
     */
    public function getBilling_address()
    {
        return $this->billing_address;
    }
    /**
     * Set billing_address value
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $billing_address
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setBilling_address(\App\Api\Client\Magento\Type\StructType\SalesOrderAddressEntity $billing_address = null)
    {
        $this->billing_address = $billing_address;
        return $this;
    }
    /**
     * Get items value
     * @return \App\Api\Client\Magento\Type\ArrayType\SalesOrderItemEntityArray|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderItemEntityArray $items
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setItems(\App\Api\Client\Magento\Type\ArrayType\SalesOrderItemEntityArray $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get payment value
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderPaymentEntity|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderPaymentEntity $payment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setPayment(\App\Api\Client\Magento\Type\StructType\SalesOrderPaymentEntity $payment = null)
    {
        $this->payment = $payment;
        return $this;
    }
    /**
     * Get status_history value
     * @return \App\Api\Client\Magento\Type\ArrayType\SalesOrderStatusHistoryEntityArray|null
     */
    public function getStatus_history()
    {
        return $this->status_history;
    }
    /**
     * Set status_history value
     * @param \App\Api\Client\Magento\Type\ArrayType\SalesOrderStatusHistoryEntityArray $status_history
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public function setStatus_history(\App\Api\Client\Magento\Type\ArrayType\SalesOrderStatusHistoryEntityArray $status_history = null)
    {
        $this->status_history = $status_history;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
