<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for salesOrderCreditmemoCreateRequestParam StructType
 * @subpackage Structs
 */
class SalesOrderCreditmemoCreateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The orderIncrementId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $orderIncrementId;
    /**
     * The creditmemoData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoData
     */
    public $creditmemoData;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The notifyCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $notifyCustomer;
    /**
     * The includeComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $includeComment;
    /**
     * The refundToStoreCreditAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $refundToStoreCreditAmount;
    /**
     * Constructor method for salesOrderCreditmemoCreateRequestParam
     * @uses SalesOrderCreditmemoCreateRequestParam::setSessionId()
     * @uses SalesOrderCreditmemoCreateRequestParam::setOrderIncrementId()
     * @uses SalesOrderCreditmemoCreateRequestParam::setCreditmemoData()
     * @uses SalesOrderCreditmemoCreateRequestParam::setComment()
     * @uses SalesOrderCreditmemoCreateRequestParam::setNotifyCustomer()
     * @uses SalesOrderCreditmemoCreateRequestParam::setIncludeComment()
     * @uses SalesOrderCreditmemoCreateRequestParam::setRefundToStoreCreditAmount()
     * @param string $sessionId
     * @param string $orderIncrementId
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoData $creditmemoData
     * @param string $comment
     * @param int $notifyCustomer
     * @param int $includeComment
     * @param string $refundToStoreCreditAmount
     */
    public function __construct($sessionId = null, $orderIncrementId = null, \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoData $creditmemoData = null, $comment = null, $notifyCustomer = null, $includeComment = null, $refundToStoreCreditAmount = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setOrderIncrementId($orderIncrementId)
            ->setCreditmemoData($creditmemoData)
            ->setComment($comment)
            ->setNotifyCustomer($notifyCustomer)
            ->setIncludeComment($includeComment)
            ->setRefundToStoreCreditAmount($refundToStoreCreditAmount);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get orderIncrementId value
     * @return string
     */
    public function getOrderIncrementId()
    {
        return $this->orderIncrementId;
    }
    /**
     * Set orderIncrementId value
     * @param string $orderIncrementId
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public function setOrderIncrementId($orderIncrementId = null)
    {
        // validation for constraint: string
        if (!is_null($orderIncrementId) && !is_string($orderIncrementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderIncrementId)), __LINE__);
        }
        $this->orderIncrementId = $orderIncrementId;
        return $this;
    }
    /**
     * Get creditmemoData value
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoData|null
     */
    public function getCreditmemoData()
    {
        return $this->creditmemoData;
    }
    /**
     * Set creditmemoData value
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoData $creditmemoData
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public function setCreditmemoData(\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoData $creditmemoData = null)
    {
        $this->creditmemoData = $creditmemoData;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get notifyCustomer value
     * @return int|null
     */
    public function getNotifyCustomer()
    {
        return $this->notifyCustomer;
    }
    /**
     * Set notifyCustomer value
     * @param int $notifyCustomer
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public function setNotifyCustomer($notifyCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($notifyCustomer) && !is_numeric($notifyCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notifyCustomer)), __LINE__);
        }
        $this->notifyCustomer = $notifyCustomer;
        return $this;
    }
    /**
     * Get includeComment value
     * @return int|null
     */
    public function getIncludeComment()
    {
        return $this->includeComment;
    }
    /**
     * Set includeComment value
     * @param int $includeComment
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public function setIncludeComment($includeComment = null)
    {
        // validation for constraint: int
        if (!is_null($includeComment) && !is_numeric($includeComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($includeComment)), __LINE__);
        }
        $this->includeComment = $includeComment;
        return $this;
    }
    /**
     * Get refundToStoreCreditAmount value
     * @return string|null
     */
    public function getRefundToStoreCreditAmount()
    {
        return $this->refundToStoreCreditAmount;
    }
    /**
     * Set refundToStoreCreditAmount value
     * @param string $refundToStoreCreditAmount
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public function setRefundToStoreCreditAmount($refundToStoreCreditAmount = null)
    {
        // validation for constraint: string
        if (!is_null($refundToStoreCreditAmount) && !is_string($refundToStoreCreditAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refundToStoreCreditAmount)), __LINE__);
        }
        $this->refundToStoreCreditAmount = $refundToStoreCreditAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
