<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resourceFaultsParam StructType
 * @subpackage Structs
 */
class ResourceFaultsParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The resourceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $resourceName;
    /**
     * Constructor method for resourceFaultsParam
     * @uses ResourceFaultsParam::setSessionId()
     * @uses ResourceFaultsParam::setResourceName()
     * @param string $sessionId
     * @param string $resourceName
     */
    public function __construct($sessionId = null, $resourceName = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setResourceName($resourceName);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\ResourceFaultsParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get resourceName value
     * @return string
     */
    public function getResourceName()
    {
        return $this->resourceName;
    }
    /**
     * Set resourceName value
     * @param string $resourceName
     * @return \App\Api\Client\Magento\Type\StructType\ResourceFaultsParam
     */
    public function setResourceName($resourceName = null)
    {
        // validation for constraint: string
        if (!is_null($resourceName) && !is_string($resourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resourceName)), __LINE__);
        }
        $this->resourceName = $resourceName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ResourceFaultsParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
