<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giftMessageResponse StructType
 * @subpackage Structs
 */
class GiftMessageResponse extends AbstractStructBase
{
    /**
     * The entityId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $entityId;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $result;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $error;
    /**
     * Constructor method for giftMessageResponse
     * @uses GiftMessageResponse::setEntityId()
     * @uses GiftMessageResponse::setResult()
     * @uses GiftMessageResponse::setError()
     * @param string $entityId
     * @param bool $result
     * @param string $error
     */
    public function __construct($entityId = null, $result = null, $error = null)
    {
        $this
            ->setEntityId($entityId)
            ->setResult($result)
            ->setError($error);
    }
    /**
     * Get entityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->entityId;
    }
    /**
     * Set entityId value
     * @param string $entityId
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageResponse
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityId)), __LINE__);
        }
        $this->entityId = $entityId;
        return $this;
    }
    /**
     * Get result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param bool $result
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get error value
     * @return string|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param string $error
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error)), __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
