<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giftMessageForQuoteItemRequestParam StructType
 * @subpackage Structs
 */
class GiftMessageForQuoteItemRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The quoteItemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $quoteItemId;
    /**
     * The giftMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\GiftMessageEntity
     */
    public $giftMessage;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for giftMessageForQuoteItemRequestParam
     * @uses GiftMessageForQuoteItemRequestParam::setSessionId()
     * @uses GiftMessageForQuoteItemRequestParam::setQuoteItemId()
     * @uses GiftMessageForQuoteItemRequestParam::setGiftMessage()
     * @uses GiftMessageForQuoteItemRequestParam::setStore()
     * @param string $sessionId
     * @param string $quoteItemId
     * @param \App\Api\Client\Magento\Type\StructType\GiftMessageEntity $giftMessage
     * @param string $store
     */
    public function __construct($sessionId = null, $quoteItemId = null, \App\Api\Client\Magento\Type\StructType\GiftMessageEntity $giftMessage = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setQuoteItemId($quoteItemId)
            ->setGiftMessage($giftMessage)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get quoteItemId value
     * @return string
     */
    public function getQuoteItemId()
    {
        return $this->quoteItemId;
    }
    /**
     * Set quoteItemId value
     * @param string $quoteItemId
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam
     */
    public function setQuoteItemId($quoteItemId = null)
    {
        // validation for constraint: string
        if (!is_null($quoteItemId) && !is_string($quoteItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quoteItemId)), __LINE__);
        }
        $this->quoteItemId = $quoteItemId;
        return $this;
    }
    /**
     * Get giftMessage value
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageEntity
     */
    public function getGiftMessage()
    {
        return $this->giftMessage;
    }
    /**
     * Set giftMessage value
     * @param \App\Api\Client\Magento\Type\StructType\GiftMessageEntity $giftMessage
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam
     */
    public function setGiftMessage(\App\Api\Client\Magento\Type\StructType\GiftMessageEntity $giftMessage = null)
    {
        $this->giftMessage = $giftMessage;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
