<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerAddressEntityCreate StructType
 * @subpackage Structs
 */
class CustomerAddressEntityCreate extends AbstractStructBase
{
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $company;
    /**
     * The country_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country_id;
    /**
     * The fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The middlename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middlename;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The region_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $region_id;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $street;
    /**
     * The suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $suffix;
    /**
     * The telephone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telephone;
    /**
     * The is_default_billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $is_default_billing;
    /**
     * The is_default_shipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $is_default_shipping;
    /**
     * Constructor method for customerAddressEntityCreate
     * @uses CustomerAddressEntityCreate::setCity()
     * @uses CustomerAddressEntityCreate::setCompany()
     * @uses CustomerAddressEntityCreate::setCountry_id()
     * @uses CustomerAddressEntityCreate::setFax()
     * @uses CustomerAddressEntityCreate::setFirstname()
     * @uses CustomerAddressEntityCreate::setLastname()
     * @uses CustomerAddressEntityCreate::setMiddlename()
     * @uses CustomerAddressEntityCreate::setPostcode()
     * @uses CustomerAddressEntityCreate::setPrefix()
     * @uses CustomerAddressEntityCreate::setRegion_id()
     * @uses CustomerAddressEntityCreate::setRegion()
     * @uses CustomerAddressEntityCreate::setStreet()
     * @uses CustomerAddressEntityCreate::setSuffix()
     * @uses CustomerAddressEntityCreate::setTelephone()
     * @uses CustomerAddressEntityCreate::setIs_default_billing()
     * @uses CustomerAddressEntityCreate::setIs_default_shipping()
     * @param string $city
     * @param string $company
     * @param string $country_id
     * @param string $fax
     * @param string $firstname
     * @param string $lastname
     * @param string $middlename
     * @param string $postcode
     * @param string $prefix
     * @param int $region_id
     * @param string $region
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $street
     * @param string $suffix
     * @param string $telephone
     * @param bool $is_default_billing
     * @param bool $is_default_shipping
     */
    public function __construct($city = null, $company = null, $country_id = null, $fax = null, $firstname = null, $lastname = null, $middlename = null, $postcode = null, $prefix = null, $region_id = null, $region = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $street = null, $suffix = null, $telephone = null, $is_default_billing = null, $is_default_shipping = null)
    {
        $this
            ->setCity($city)
            ->setCompany($company)
            ->setCountry_id($country_id)
            ->setFax($fax)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setMiddlename($middlename)
            ->setPostcode($postcode)
            ->setPrefix($prefix)
            ->setRegion_id($region_id)
            ->setRegion($region)
            ->setStreet($street)
            ->setSuffix($suffix)
            ->setTelephone($telephone)
            ->setIs_default_billing($is_default_billing)
            ->setIs_default_shipping($is_default_shipping);
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get country_id value
     * @return string|null
     */
    public function getCountry_id()
    {
        return $this->country_id;
    }
    /**
     * Set country_id value
     * @param string $country_id
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setCountry_id($country_id = null)
    {
        // validation for constraint: string
        if (!is_null($country_id) && !is_string($country_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_id)), __LINE__);
        }
        $this->country_id = $country_id;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get middlename value
     * @return string|null
     */
    public function getMiddlename()
    {
        return $this->middlename;
    }
    /**
     * Set middlename value
     * @param string $middlename
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setMiddlename($middlename = null)
    {
        // validation for constraint: string
        if (!is_null($middlename) && !is_string($middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middlename)), __LINE__);
        }
        $this->middlename = $middlename;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get region_id value
     * @return int|null
     */
    public function getRegion_id()
    {
        return $this->region_id;
    }
    /**
     * Set region_id value
     * @param int $region_id
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setRegion_id($region_id = null)
    {
        // validation for constraint: int
        if (!is_null($region_id) && !is_numeric($region_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($region_id)), __LINE__);
        }
        $this->region_id = $region_id;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get street value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $street
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setStreet(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $street = null)
    {
        $this->street = $street;
        return $this;
    }
    /**
     * Get suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->suffix;
    }
    /**
     * Set suffix value
     * @param string $suffix
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffix)), __LINE__);
        }
        $this->suffix = $suffix;
        return $this;
    }
    /**
     * Get telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
    /**
     * Set telephone value
     * @param string $telephone
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->telephone = $telephone;
        return $this;
    }
    /**
     * Get is_default_billing value
     * @return bool|null
     */
    public function getIs_default_billing()
    {
        return $this->is_default_billing;
    }
    /**
     * Set is_default_billing value
     * @param bool $is_default_billing
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setIs_default_billing($is_default_billing = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_default_billing) && !is_bool($is_default_billing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_default_billing)), __LINE__);
        }
        $this->is_default_billing = $is_default_billing;
        return $this;
    }
    /**
     * Get is_default_shipping value
     * @return bool|null
     */
    public function getIs_default_shipping()
    {
        return $this->is_default_shipping;
    }
    /**
     * Set is_default_shipping value
     * @param bool $is_default_shipping
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function setIs_default_shipping($is_default_shipping = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_default_shipping) && !is_bool($is_default_shipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_default_shipping)), __LINE__);
        }
        $this->is_default_shipping = $is_default_shipping;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
