<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerAddressCreateRequestParam StructType
 * @subpackage Structs
 */
class CustomerAddressCreateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The addressData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public $addressData;
    /**
     * Constructor method for customerAddressCreateRequestParam
     * @uses CustomerAddressCreateRequestParam::setSessionId()
     * @uses CustomerAddressCreateRequestParam::setCustomerId()
     * @uses CustomerAddressCreateRequestParam::setAddressData()
     * @param string $sessionId
     * @param int $customerId
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData
     */
    public function __construct($sessionId = null, $customerId = null, \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setCustomerId($customerId)
            ->setAddressData($addressData);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateRequestParam
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get addressData value
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate
     */
    public function getAddressData()
    {
        return $this->addressData;
    }
    /**
     * Set addressData value
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateRequestParam
     */
    public function setAddressData(\App\Api\Client\Magento\Type\StructType\CustomerAddressEntityCreate $addressData = null)
    {
        $this->addressData = $addressData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
