<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductTagListEntity StructType
 * @subpackage Structs
 */
class CatalogProductTagListEntity extends AbstractStructBase
{
    /**
     * The tag_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tag_id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * Constructor method for catalogProductTagListEntity
     * @uses CatalogProductTagListEntity::setTag_id()
     * @uses CatalogProductTagListEntity::setName()
     * @param string $tag_id
     * @param string $name
     */
    public function __construct($tag_id = null, $name = null)
    {
        $this
            ->setTag_id($tag_id)
            ->setName($name);
    }
    /**
     * Get tag_id value
     * @return string
     */
    public function getTag_id()
    {
        return $this->tag_id;
    }
    /**
     * Set tag_id value
     * @param string $tag_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagListEntity
     */
    public function setTag_id($tag_id = null)
    {
        // validation for constraint: string
        if (!is_null($tag_id) && !is_string($tag_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tag_id)), __LINE__);
        }
        $this->tag_id = $tag_id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagListEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagListEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
