<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductTagAddEntity StructType
 * @subpackage Structs
 */
class CatalogProductTagAddEntity extends AbstractStructBase
{
    /**
     * The tag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tag;
    /**
     * The product_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product_id;
    /**
     * The customer_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customer_id;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $store;
    /**
     * Constructor method for catalogProductTagAddEntity
     * @uses CatalogProductTagAddEntity::setTag()
     * @uses CatalogProductTagAddEntity::setProduct_id()
     * @uses CatalogProductTagAddEntity::setCustomer_id()
     * @uses CatalogProductTagAddEntity::setStore()
     * @param string $tag
     * @param string $product_id
     * @param string $customer_id
     * @param string $store
     */
    public function __construct($tag = null, $product_id = null, $customer_id = null, $store = null)
    {
        $this
            ->setTag($tag)
            ->setProduct_id($product_id)
            ->setCustomer_id($customer_id)
            ->setStore($store);
    }
    /**
     * Get tag value
     * @return string
     */
    public function getTag()
    {
        return $this->tag;
    }
    /**
     * Set tag value
     * @param string $tag
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddEntity
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tag)), __LINE__);
        }
        $this->tag = $tag;
        return $this;
    }
    /**
     * Get product_id value
     * @return string
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get customer_id value
     * @return string
     */
    public function getCustomer_id()
    {
        return $this->customer_id;
    }
    /**
     * Set customer_id value
     * @param string $customer_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddEntity
     */
    public function setCustomer_id($customer_id = null)
    {
        // validation for constraint: string
        if (!is_null($customer_id) && !is_string($customer_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_id)), __LINE__);
        }
        $this->customer_id = $customer_id;
        return $this;
    }
    /**
     * Get store value
     * @return string
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddEntity
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductTagAddEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
