<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductMultiUpdateRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductMultiUpdateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The productIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $productIds;
    /**
     * The productData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\ArrayType\CatalogProductCreateEntityArray
     */
    public $productData;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * The identifierType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identifierType;
    /**
     * Constructor method for catalogProductMultiUpdateRequestParam
     * @uses CatalogProductMultiUpdateRequestParam::setSessionId()
     * @uses CatalogProductMultiUpdateRequestParam::setProductIds()
     * @uses CatalogProductMultiUpdateRequestParam::setProductData()
     * @uses CatalogProductMultiUpdateRequestParam::setStore()
     * @uses CatalogProductMultiUpdateRequestParam::setIdentifierType()
     * @param string $sessionId
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds
     * @param \App\Api\Client\Magento\Type\ArrayType\CatalogProductCreateEntityArray $productData
     * @param string $store
     * @param string $identifierType
     */
    public function __construct($sessionId = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds = null, \App\Api\Client\Magento\Type\ArrayType\CatalogProductCreateEntityArray $productData = null, $store = null, $identifierType = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setProductIds($productIds)
            ->setProductData($productData)
            ->setStore($store)
            ->setIdentifierType($identifierType);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get productIds value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public function getProductIds()
    {
        return $this->productIds;
    }
    /**
     * Set productIds value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam
     */
    public function setProductIds(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds = null)
    {
        $this->productIds = $productIds;
        return $this;
    }
    /**
     * Get productData value
     * @return \App\Api\Client\Magento\Type\ArrayType\CatalogProductCreateEntityArray
     */
    public function getProductData()
    {
        return $this->productData;
    }
    /**
     * Set productData value
     * @param \App\Api\Client\Magento\Type\ArrayType\CatalogProductCreateEntityArray $productData
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam
     */
    public function setProductData(\App\Api\Client\Magento\Type\ArrayType\CatalogProductCreateEntityArray $productData = null)
    {
        $this->productData = $productData;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Get identifierType value
     * @return string|null
     */
    public function getIdentifierType()
    {
        return $this->identifierType;
    }
    /**
     * Set identifierType value
     * @param string $identifierType
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: string
        if (!is_null($identifierType) && !is_string($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierType)), __LINE__);
        }
        $this->identifierType = $identifierType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductMultiUpdateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
