<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductLinkUpdateRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductLinkUpdateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $productId;
    /**
     * The linkedProductId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $linkedProductId;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity
     */
    public $data;
    /**
     * The identifierType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identifierType;
    /**
     * Constructor method for catalogProductLinkUpdateRequestParam
     * @uses CatalogProductLinkUpdateRequestParam::setSessionId()
     * @uses CatalogProductLinkUpdateRequestParam::setType()
     * @uses CatalogProductLinkUpdateRequestParam::setProductId()
     * @uses CatalogProductLinkUpdateRequestParam::setLinkedProductId()
     * @uses CatalogProductLinkUpdateRequestParam::setData()
     * @uses CatalogProductLinkUpdateRequestParam::setIdentifierType()
     * @param string $sessionId
     * @param string $type
     * @param string $productId
     * @param string $linkedProductId
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity $data
     * @param string $identifierType
     */
    public function __construct($sessionId = null, $type = null, $productId = null, $linkedProductId = null, \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity $data = null, $identifierType = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setType($type)
            ->setProductId($productId)
            ->setLinkedProductId($linkedProductId)
            ->setData($data)
            ->setIdentifierType($identifierType);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get productId value
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get linkedProductId value
     * @return string
     */
    public function getLinkedProductId()
    {
        return $this->linkedProductId;
    }
    /**
     * Set linkedProductId value
     * @param string $linkedProductId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam
     */
    public function setLinkedProductId($linkedProductId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedProductId) && !is_string($linkedProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linkedProductId)), __LINE__);
        }
        $this->linkedProductId = $linkedProductId;
        return $this;
    }
    /**
     * Get data value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity $data
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam
     */
    public function setData(\App\Api\Client\Magento\Type\StructType\CatalogProductLinkEntity $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get identifierType value
     * @return string|null
     */
    public function getIdentifierType()
    {
        return $this->identifierType;
    }
    /**
     * Set identifierType value
     * @param string $identifierType
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: string
        if (!is_null($identifierType) && !is_string($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierType)), __LINE__);
        }
        $this->identifierType = $identifierType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkUpdateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
