<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductLinkRemoveRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductLinkRemoveRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The productId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $productId;
    /**
     * The linkedProductId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $linkedProductId;
    /**
     * The identifierType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identifierType;
    /**
     * Constructor method for catalogProductLinkRemoveRequestParam
     * @uses CatalogProductLinkRemoveRequestParam::setSessionId()
     * @uses CatalogProductLinkRemoveRequestParam::setType()
     * @uses CatalogProductLinkRemoveRequestParam::setProductId()
     * @uses CatalogProductLinkRemoveRequestParam::setLinkedProductId()
     * @uses CatalogProductLinkRemoveRequestParam::setIdentifierType()
     * @param string $sessionId
     * @param string $type
     * @param string $productId
     * @param string $linkedProductId
     * @param string $identifierType
     */
    public function __construct($sessionId = null, $type = null, $productId = null, $linkedProductId = null, $identifierType = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setType($type)
            ->setProductId($productId)
            ->setLinkedProductId($linkedProductId)
            ->setIdentifierType($identifierType);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get productId value
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get linkedProductId value
     * @return string
     */
    public function getLinkedProductId()
    {
        return $this->linkedProductId;
    }
    /**
     * Set linkedProductId value
     * @param string $linkedProductId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam
     */
    public function setLinkedProductId($linkedProductId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedProductId) && !is_string($linkedProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linkedProductId)), __LINE__);
        }
        $this->linkedProductId = $linkedProductId;
        return $this;
    }
    /**
     * Get identifierType value
     * @return string|null
     */
    public function getIdentifierType()
    {
        return $this->identifierType;
    }
    /**
     * Set identifierType value
     * @param string $identifierType
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: string
        if (!is_null($identifierType) && !is_string($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierType)), __LINE__);
        }
        $this->identifierType = $identifierType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductLinkRemoveRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
