<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductImageFileEntity StructType
 * @subpackage Structs
 */
class CatalogProductImageFileEntity extends AbstractStructBase
{
    /**
     * The content
     * @var string
     */
    public $content;
    /**
     * The mime
     * @var string
     */
    public $mime;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for catalogProductImageFileEntity
     * @uses CatalogProductImageFileEntity::setContent()
     * @uses CatalogProductImageFileEntity::setMime()
     * @uses CatalogProductImageFileEntity::setName()
     * @param string $content
     * @param string $mime
     * @param string $name
     */
    public function __construct($content = null, $mime = null, $name = null)
    {
        $this
            ->setContent($content)
            ->setMime($mime)
            ->setName($name);
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageFileEntity
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get mime value
     * @return string|null
     */
    public function getMime()
    {
        return $this->mime;
    }
    /**
     * Set mime value
     * @param string $mime
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageFileEntity
     */
    public function setMime($mime = null)
    {
        // validation for constraint: string
        if (!is_null($mime) && !is_string($mime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mime)), __LINE__);
        }
        $this->mime = $mime;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageFileEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageFileEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
