<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductImageEntity StructType
 * @subpackage Structs
 */
class CatalogProductImageEntity extends AbstractStructBase
{
    /**
     * The file
     * @var string
     */
    public $file;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The position
     * @var string
     */
    public $position;
    /**
     * The exclude
     * @var string
     */
    public $exclude;
    /**
     * The url
     * @var string
     */
    public $url;
    /**
     * The types
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $types;
    /**
     * Constructor method for catalogProductImageEntity
     * @uses CatalogProductImageEntity::setFile()
     * @uses CatalogProductImageEntity::setLabel()
     * @uses CatalogProductImageEntity::setPosition()
     * @uses CatalogProductImageEntity::setExclude()
     * @uses CatalogProductImageEntity::setUrl()
     * @uses CatalogProductImageEntity::setTypes()
     * @param string $file
     * @param string $label
     * @param string $position
     * @param string $exclude
     * @param string $url
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $types
     */
    public function __construct($file = null, $label = null, $position = null, $exclude = null, $url = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $types = null)
    {
        $this
            ->setFile($file)
            ->setLabel($label)
            ->setPosition($position)
            ->setExclude($exclude)
            ->setUrl($url)
            ->setTypes($types);
    }
    /**
     * Get file value
     * @return string|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param string $file
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageEntity
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($file)), __LINE__);
        }
        $this->file = $file;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageEntity
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageEntity
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get exclude value
     * @return string|null
     */
    public function getExclude()
    {
        return $this->exclude;
    }
    /**
     * Set exclude value
     * @param string $exclude
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageEntity
     */
    public function setExclude($exclude = null)
    {
        // validation for constraint: string
        if (!is_null($exclude) && !is_string($exclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exclude)), __LINE__);
        }
        $this->exclude = $exclude;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageEntity
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get types value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getTypes()
    {
        return $this->types;
    }
    /**
     * Set types value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $types
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageEntity
     */
    public function setTypes(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $types = null)
    {
        $this->types = $types;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductImageEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
