<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductDownloadableLinkRemoveRequestParam
 * StructType
 * @subpackage Structs
 */
class CatalogProductDownloadableLinkRemoveRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The linkId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $linkId;
    /**
     * The resourceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $resourceType;
    /**
     * Constructor method for catalogProductDownloadableLinkRemoveRequestParam
     * @uses CatalogProductDownloadableLinkRemoveRequestParam::setSessionId()
     * @uses CatalogProductDownloadableLinkRemoveRequestParam::setLinkId()
     * @uses CatalogProductDownloadableLinkRemoveRequestParam::setResourceType()
     * @param string $sessionId
     * @param string $linkId
     * @param string $resourceType
     */
    public function __construct($sessionId = null, $linkId = null, $resourceType = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setLinkId($linkId)
            ->setResourceType($resourceType);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get linkId value
     * @return string
     */
    public function getLinkId()
    {
        return $this->linkId;
    }
    /**
     * Set linkId value
     * @param string $linkId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveRequestParam
     */
    public function setLinkId($linkId = null)
    {
        // validation for constraint: string
        if (!is_null($linkId) && !is_string($linkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linkId)), __LINE__);
        }
        $this->linkId = $linkId;
        return $this;
    }
    /**
     * Get resourceType value
     * @return string
     */
    public function getResourceType()
    {
        return $this->resourceType;
    }
    /**
     * Set resourceType value
     * @param string $resourceType
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveRequestParam
     */
    public function setResourceType($resourceType = null)
    {
        // validation for constraint: string
        if (!is_null($resourceType) && !is_string($resourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resourceType)), __LINE__);
        }
        $this->resourceType = $resourceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkRemoveRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
