<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductDownloadableLinkFileInfoEntity StructType
 * @subpackage Structs
 */
class CatalogProductDownloadableLinkFileInfoEntity extends AbstractStructBase
{
    /**
     * The file
     * @var string
     */
    public $file;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The size
     * @var int
     */
    public $size;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for catalogProductDownloadableLinkFileInfoEntity
     * @uses CatalogProductDownloadableLinkFileInfoEntity::setFile()
     * @uses CatalogProductDownloadableLinkFileInfoEntity::setName()
     * @uses CatalogProductDownloadableLinkFileInfoEntity::setSize()
     * @uses CatalogProductDownloadableLinkFileInfoEntity::setStatus()
     * @param string $file
     * @param string $name
     * @param int $size
     * @param string $status
     */
    public function __construct($file = null, $name = null, $size = null, $status = null)
    {
        $this
            ->setFile($file)
            ->setName($name)
            ->setSize($size)
            ->setStatus($status);
    }
    /**
     * Get file value
     * @return string|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param string $file
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileInfoEntity
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($file)), __LINE__);
        }
        $this->file = $file;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileInfoEntity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileInfoEntity
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileInfoEntity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkFileInfoEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
