<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductDownloadableLinkEntity StructType
 * @subpackage Structs
 */
class CatalogProductDownloadableLinkEntity extends AbstractStructBase
{
    /**
     * The link_id
     * @var string
     */
    public $link_id;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The price
     * @var string
     */
    public $price;
    /**
     * The number_of_downloads
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number_of_downloads;
    /**
     * The is_unlimited
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_unlimited;
    /**
     * The is_shareable
     * @var int
     */
    public $is_shareable;
    /**
     * The link_url
     * @var string
     */
    public $link_url;
    /**
     * The link_type
     * @var string
     */
    public $link_type;
    /**
     * The sample_file
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sample_file;
    /**
     * The sample_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sample_url;
    /**
     * The sample_type
     * @var string
     */
    public $sample_type;
    /**
     * The sort_order
     * @var int
     */
    public $sort_order;
    /**
     * The file_save
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray
     */
    public $file_save;
    /**
     * The sample_file_save
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray
     */
    public $sample_file_save;
    /**
     * Constructor method for catalogProductDownloadableLinkEntity
     * @uses CatalogProductDownloadableLinkEntity::setLink_id()
     * @uses CatalogProductDownloadableLinkEntity::setTitle()
     * @uses CatalogProductDownloadableLinkEntity::setPrice()
     * @uses CatalogProductDownloadableLinkEntity::setNumber_of_downloads()
     * @uses CatalogProductDownloadableLinkEntity::setIs_unlimited()
     * @uses CatalogProductDownloadableLinkEntity::setIs_shareable()
     * @uses CatalogProductDownloadableLinkEntity::setLink_url()
     * @uses CatalogProductDownloadableLinkEntity::setLink_type()
     * @uses CatalogProductDownloadableLinkEntity::setSample_file()
     * @uses CatalogProductDownloadableLinkEntity::setSample_url()
     * @uses CatalogProductDownloadableLinkEntity::setSample_type()
     * @uses CatalogProductDownloadableLinkEntity::setSort_order()
     * @uses CatalogProductDownloadableLinkEntity::setFile_save()
     * @uses CatalogProductDownloadableLinkEntity::setSample_file_save()
     * @param string $link_id
     * @param string $title
     * @param string $price
     * @param int $number_of_downloads
     * @param int $is_unlimited
     * @param int $is_shareable
     * @param string $link_url
     * @param string $link_type
     * @param string $sample_file
     * @param string $sample_url
     * @param string $sample_type
     * @param int $sort_order
     * @param \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $file_save
     * @param \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $sample_file_save
     */
    public function __construct($link_id = null, $title = null, $price = null, $number_of_downloads = null, $is_unlimited = null, $is_shareable = null, $link_url = null, $link_type = null, $sample_file = null, $sample_url = null, $sample_type = null, $sort_order = null, \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $file_save = null, \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $sample_file_save = null)
    {
        $this
            ->setLink_id($link_id)
            ->setTitle($title)
            ->setPrice($price)
            ->setNumber_of_downloads($number_of_downloads)
            ->setIs_unlimited($is_unlimited)
            ->setIs_shareable($is_shareable)
            ->setLink_url($link_url)
            ->setLink_type($link_type)
            ->setSample_file($sample_file)
            ->setSample_url($sample_url)
            ->setSample_type($sample_type)
            ->setSort_order($sort_order)
            ->setFile_save($file_save)
            ->setSample_file_save($sample_file_save);
    }
    /**
     * Get link_id value
     * @return string|null
     */
    public function getLink_id()
    {
        return $this->link_id;
    }
    /**
     * Set link_id value
     * @param string $link_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setLink_id($link_id = null)
    {
        // validation for constraint: string
        if (!is_null($link_id) && !is_string($link_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link_id)), __LINE__);
        }
        $this->link_id = $link_id;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get price value
     * @return string|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param string $price
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setPrice($price = null)
    {
        // validation for constraint: string
        if (!is_null($price) && !is_string($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get number_of_downloads value
     * @return int|null
     */
    public function getNumber_of_downloads()
    {
        return $this->number_of_downloads;
    }
    /**
     * Set number_of_downloads value
     * @param int $number_of_downloads
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setNumber_of_downloads($number_of_downloads = null)
    {
        // validation for constraint: int
        if (!is_null($number_of_downloads) && !is_numeric($number_of_downloads)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number_of_downloads)), __LINE__);
        }
        $this->number_of_downloads = $number_of_downloads;
        return $this;
    }
    /**
     * Get is_unlimited value
     * @return int|null
     */
    public function getIs_unlimited()
    {
        return $this->is_unlimited;
    }
    /**
     * Set is_unlimited value
     * @param int $is_unlimited
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setIs_unlimited($is_unlimited = null)
    {
        // validation for constraint: int
        if (!is_null($is_unlimited) && !is_numeric($is_unlimited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_unlimited)), __LINE__);
        }
        $this->is_unlimited = $is_unlimited;
        return $this;
    }
    /**
     * Get is_shareable value
     * @return int|null
     */
    public function getIs_shareable()
    {
        return $this->is_shareable;
    }
    /**
     * Set is_shareable value
     * @param int $is_shareable
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setIs_shareable($is_shareable = null)
    {
        // validation for constraint: int
        if (!is_null($is_shareable) && !is_numeric($is_shareable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_shareable)), __LINE__);
        }
        $this->is_shareable = $is_shareable;
        return $this;
    }
    /**
     * Get link_url value
     * @return string|null
     */
    public function getLink_url()
    {
        return $this->link_url;
    }
    /**
     * Set link_url value
     * @param string $link_url
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setLink_url($link_url = null)
    {
        // validation for constraint: string
        if (!is_null($link_url) && !is_string($link_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link_url)), __LINE__);
        }
        $this->link_url = $link_url;
        return $this;
    }
    /**
     * Get link_type value
     * @return string|null
     */
    public function getLink_type()
    {
        return $this->link_type;
    }
    /**
     * Set link_type value
     * @param string $link_type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setLink_type($link_type = null)
    {
        // validation for constraint: string
        if (!is_null($link_type) && !is_string($link_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link_type)), __LINE__);
        }
        $this->link_type = $link_type;
        return $this;
    }
    /**
     * Get sample_file value
     * @return string|null
     */
    public function getSample_file()
    {
        return $this->sample_file;
    }
    /**
     * Set sample_file value
     * @param string $sample_file
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setSample_file($sample_file = null)
    {
        // validation for constraint: string
        if (!is_null($sample_file) && !is_string($sample_file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_file)), __LINE__);
        }
        $this->sample_file = $sample_file;
        return $this;
    }
    /**
     * Get sample_url value
     * @return string|null
     */
    public function getSample_url()
    {
        return $this->sample_url;
    }
    /**
     * Set sample_url value
     * @param string $sample_url
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setSample_url($sample_url = null)
    {
        // validation for constraint: string
        if (!is_null($sample_url) && !is_string($sample_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_url)), __LINE__);
        }
        $this->sample_url = $sample_url;
        return $this;
    }
    /**
     * Get sample_type value
     * @return string|null
     */
    public function getSample_type()
    {
        return $this->sample_type;
    }
    /**
     * Set sample_type value
     * @param string $sample_type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setSample_type($sample_type = null)
    {
        // validation for constraint: string
        if (!is_null($sample_type) && !is_string($sample_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sample_type)), __LINE__);
        }
        $this->sample_type = $sample_type;
        return $this;
    }
    /**
     * Get sort_order value
     * @return int|null
     */
    public function getSort_order()
    {
        return $this->sort_order;
    }
    /**
     * Set sort_order value
     * @param int $sort_order
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setSort_order($sort_order = null)
    {
        // validation for constraint: int
        if (!is_null($sort_order) && !is_numeric($sort_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort_order)), __LINE__);
        }
        $this->sort_order = $sort_order;
        return $this;
    }
    /**
     * Get file_save value
     * @return \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray|null
     */
    public function getFile_save()
    {
        return $this->file_save;
    }
    /**
     * Set file_save value
     * @param \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $file_save
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setFile_save(\App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $file_save = null)
    {
        $this->file_save = $file_save;
        return $this;
    }
    /**
     * Get sample_file_save value
     * @return \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray|null
     */
    public function getSample_file_save()
    {
        return $this->sample_file_save;
    }
    /**
     * Set sample_file_save value
     * @param \App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $sample_file_save
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public function setSample_file_save(\App\Api\Client\Magento\Type\ArrayType\CatalogProductDownloadableLinkFileInfoEntityArray $sample_file_save = null)
    {
        $this->sample_file_save = $sample_file_save;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductDownloadableLinkEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
