<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeSetRemoveRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductAttributeSetRemoveRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The attributeSetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeSetId;
    /**
     * The forceProductsRemove
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $forceProductsRemove;
    /**
     * Constructor method for catalogProductAttributeSetRemoveRequestParam
     * @uses CatalogProductAttributeSetRemoveRequestParam::setSessionId()
     * @uses CatalogProductAttributeSetRemoveRequestParam::setAttributeSetId()
     * @uses CatalogProductAttributeSetRemoveRequestParam::setForceProductsRemove()
     * @param string $sessionId
     * @param string $attributeSetId
     * @param string $forceProductsRemove
     */
    public function __construct($sessionId = null, $attributeSetId = null, $forceProductsRemove = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAttributeSetId($attributeSetId)
            ->setForceProductsRemove($forceProductsRemove);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get attributeSetId value
     * @return string
     */
    public function getAttributeSetId()
    {
        return $this->attributeSetId;
    }
    /**
     * Set attributeSetId value
     * @param string $attributeSetId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveRequestParam
     */
    public function setAttributeSetId($attributeSetId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeSetId) && !is_string($attributeSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeSetId)), __LINE__);
        }
        $this->attributeSetId = $attributeSetId;
        return $this;
    }
    /**
     * Get forceProductsRemove value
     * @return string|null
     */
    public function getForceProductsRemove()
    {
        return $this->forceProductsRemove;
    }
    /**
     * Set forceProductsRemove value
     * @param string $forceProductsRemove
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveRequestParam
     */
    public function setForceProductsRemove($forceProductsRemove = null)
    {
        // validation for constraint: string
        if (!is_null($forceProductsRemove) && !is_string($forceProductsRemove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forceProductsRemove)), __LINE__);
        }
        $this->forceProductsRemove = $forceProductsRemove;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetRemoveRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
