<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeSetGroupRenameRequestParam
 * StructType
 * @subpackage Structs
 */
class CatalogProductAttributeSetGroupRenameRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The groupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $groupId;
    /**
     * The groupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $groupName;
    /**
     * Constructor method for catalogProductAttributeSetGroupRenameRequestParam
     * @uses CatalogProductAttributeSetGroupRenameRequestParam::setSessionId()
     * @uses CatalogProductAttributeSetGroupRenameRequestParam::setGroupId()
     * @uses CatalogProductAttributeSetGroupRenameRequestParam::setGroupName()
     * @param string $sessionId
     * @param string $groupId
     * @param string $groupName
     */
    public function __construct($sessionId = null, $groupId = null, $groupName = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setGroupId($groupId)
            ->setGroupName($groupName);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get groupId value
     * @return string
     */
    public function getGroupId()
    {
        return $this->groupId;
    }
    /**
     * Set groupId value
     * @param string $groupId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameRequestParam
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->groupId = $groupId;
        return $this;
    }
    /**
     * Get groupName value
     * @return string
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameRequestParam
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRenameRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
