<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeSetGroupRemoveRequestParam
 * StructType
 * @subpackage Structs
 */
class CatalogProductAttributeSetGroupRemoveRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The attributeGroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeGroupId;
    /**
     * Constructor method for catalogProductAttributeSetGroupRemoveRequestParam
     * @uses CatalogProductAttributeSetGroupRemoveRequestParam::setSessionId()
     * @uses CatalogProductAttributeSetGroupRemoveRequestParam::setAttributeGroupId()
     * @param string $sessionId
     * @param string $attributeGroupId
     */
    public function __construct($sessionId = null, $attributeGroupId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAttributeGroupId($attributeGroupId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get attributeGroupId value
     * @return string
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }
    /**
     * Set attributeGroupId value
     * @param string $attributeGroupId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveRequestParam
     */
    public function setAttributeGroupId($attributeGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeGroupId) && !is_string($attributeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeGroupId)), __LINE__);
        }
        $this->attributeGroupId = $attributeGroupId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetGroupRemoveRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
