<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeSetCreateRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductAttributeSetCreateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The attributeSetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeSetName;
    /**
     * The skeletonSetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $skeletonSetId;
    /**
     * Constructor method for catalogProductAttributeSetCreateRequestParam
     * @uses CatalogProductAttributeSetCreateRequestParam::setSessionId()
     * @uses CatalogProductAttributeSetCreateRequestParam::setAttributeSetName()
     * @uses CatalogProductAttributeSetCreateRequestParam::setSkeletonSetId()
     * @param string $sessionId
     * @param string $attributeSetName
     * @param string $skeletonSetId
     */
    public function __construct($sessionId = null, $attributeSetName = null, $skeletonSetId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAttributeSetName($attributeSetName)
            ->setSkeletonSetId($skeletonSetId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get attributeSetName value
     * @return string
     */
    public function getAttributeSetName()
    {
        return $this->attributeSetName;
    }
    /**
     * Set attributeSetName value
     * @param string $attributeSetName
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateRequestParam
     */
    public function setAttributeSetName($attributeSetName = null)
    {
        // validation for constraint: string
        if (!is_null($attributeSetName) && !is_string($attributeSetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeSetName)), __LINE__);
        }
        $this->attributeSetName = $attributeSetName;
        return $this;
    }
    /**
     * Get skeletonSetId value
     * @return string
     */
    public function getSkeletonSetId()
    {
        return $this->skeletonSetId;
    }
    /**
     * Set skeletonSetId value
     * @param string $skeletonSetId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateRequestParam
     */
    public function setSkeletonSetId($skeletonSetId = null)
    {
        // validation for constraint: string
        if (!is_null($skeletonSetId) && !is_string($skeletonSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skeletonSetId)), __LINE__);
        }
        $this->skeletonSetId = $skeletonSetId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetCreateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
