<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeSetAttributeRemoveRequestParam
 * StructType
 * @subpackage Structs
 */
class CatalogProductAttributeSetAttributeRemoveRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The attributeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeId;
    /**
     * The attributeSetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeSetId;
    /**
     * Constructor method for catalogProductAttributeSetAttributeRemoveRequestParam
     * @uses CatalogProductAttributeSetAttributeRemoveRequestParam::setSessionId()
     * @uses CatalogProductAttributeSetAttributeRemoveRequestParam::setAttributeId()
     * @uses CatalogProductAttributeSetAttributeRemoveRequestParam::setAttributeSetId()
     * @param string $sessionId
     * @param string $attributeId
     * @param string $attributeSetId
     */
    public function __construct($sessionId = null, $attributeId = null, $attributeSetId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAttributeId($attributeId)
            ->setAttributeSetId($attributeSetId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get attributeId value
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }
    /**
     * Set attributeId value
     * @param string $attributeId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveRequestParam
     */
    public function setAttributeId($attributeId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeId) && !is_string($attributeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeId)), __LINE__);
        }
        $this->attributeId = $attributeId;
        return $this;
    }
    /**
     * Get attributeSetId value
     * @return string
     */
    public function getAttributeSetId()
    {
        return $this->attributeSetId;
    }
    /**
     * Set attributeSetId value
     * @param string $attributeSetId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveRequestParam
     */
    public function setAttributeSetId($attributeSetId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeSetId) && !is_string($attributeSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeSetId)), __LINE__);
        }
        $this->attributeSetId = $attributeSetId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeRemoveRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
