<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeSetAttributeAddRequestParam
 * StructType
 * @subpackage Structs
 */
class CatalogProductAttributeSetAttributeAddRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The attributeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeId;
    /**
     * The attributeSetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attributeSetId;
    /**
     * The attributeGroupId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $attributeGroupId;
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortOrder;
    /**
     * Constructor method for catalogProductAttributeSetAttributeAddRequestParam
     * @uses CatalogProductAttributeSetAttributeAddRequestParam::setSessionId()
     * @uses CatalogProductAttributeSetAttributeAddRequestParam::setAttributeId()
     * @uses CatalogProductAttributeSetAttributeAddRequestParam::setAttributeSetId()
     * @uses CatalogProductAttributeSetAttributeAddRequestParam::setAttributeGroupId()
     * @uses CatalogProductAttributeSetAttributeAddRequestParam::setSortOrder()
     * @param string $sessionId
     * @param string $attributeId
     * @param string $attributeSetId
     * @param string $attributeGroupId
     * @param string $sortOrder
     */
    public function __construct($sessionId = null, $attributeId = null, $attributeSetId = null, $attributeGroupId = null, $sortOrder = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAttributeId($attributeId)
            ->setAttributeSetId($attributeSetId)
            ->setAttributeGroupId($attributeGroupId)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get attributeId value
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }
    /**
     * Set attributeId value
     * @param string $attributeId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam
     */
    public function setAttributeId($attributeId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeId) && !is_string($attributeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeId)), __LINE__);
        }
        $this->attributeId = $attributeId;
        return $this;
    }
    /**
     * Get attributeSetId value
     * @return string
     */
    public function getAttributeSetId()
    {
        return $this->attributeSetId;
    }
    /**
     * Set attributeSetId value
     * @param string $attributeSetId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam
     */
    public function setAttributeSetId($attributeSetId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeSetId) && !is_string($attributeSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeSetId)), __LINE__);
        }
        $this->attributeSetId = $attributeSetId;
        return $this;
    }
    /**
     * Get attributeGroupId value
     * @return string|null
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }
    /**
     * Set attributeGroupId value
     * @param string $attributeGroupId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam
     */
    public function setAttributeGroupId($attributeGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($attributeGroupId) && !is_string($attributeGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeGroupId)), __LINE__);
        }
        $this->attributeGroupId = $attributeGroupId;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @param string $sortOrder
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: string
        if (!is_null($sortOrder) && !is_string($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeSetAttributeAddRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
