<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogProductAttributeAddOptionRequestParam StructType
 * @subpackage Structs
 */
class CatalogProductAttributeAddOptionRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attribute;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionEntityToAdd
     */
    public $data;
    /**
     * Constructor method for catalogProductAttributeAddOptionRequestParam
     * @uses CatalogProductAttributeAddOptionRequestParam::setSessionId()
     * @uses CatalogProductAttributeAddOptionRequestParam::setAttribute()
     * @uses CatalogProductAttributeAddOptionRequestParam::setData()
     * @param string $sessionId
     * @param string $attribute
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionEntityToAdd $data
     */
    public function __construct($sessionId = null, $attribute = null, \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionEntityToAdd $data = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setAttribute($attribute)
            ->setData($data);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get attribute value
     * @return string
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @param string $attribute
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionRequestParam
     */
    public function setAttribute($attribute = null)
    {
        // validation for constraint: string
        if (!is_null($attribute) && !is_string($attribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attribute)), __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Get data value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionEntityToAdd
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionEntityToAdd $data
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionRequestParam
     */
    public function setData(\App\Api\Client\Magento\Type\StructType\CatalogProductAttributeOptionEntityToAdd $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogProductAttributeAddOptionRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
