<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogInventoryStockItemListRequestParam StructType
 * @subpackage Structs
 */
class CatalogInventoryStockItemListRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The productIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $productIds;
    /**
     * Constructor method for catalogInventoryStockItemListRequestParam
     * @uses CatalogInventoryStockItemListRequestParam::setSessionId()
     * @uses CatalogInventoryStockItemListRequestParam::setProductIds()
     * @param string $sessionId
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds
     */
    public function __construct($sessionId = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setProductIds($productIds);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get productIds value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public function getProductIds()
    {
        return $this->productIds;
    }
    /**
     * Set productIds value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListRequestParam
     */
    public function setProductIds(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $productIds = null)
    {
        $this->productIds = $productIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemListRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
