<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogInventoryStockItemEntity StructType
 * @subpackage Structs
 */
class CatalogInventoryStockItemEntity extends AbstractStructBase
{
    /**
     * The product_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_id;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qty;
    /**
     * The is_in_stock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $is_in_stock;
    /**
     * Constructor method for catalogInventoryStockItemEntity
     * @uses CatalogInventoryStockItemEntity::setProduct_id()
     * @uses CatalogInventoryStockItemEntity::setSku()
     * @uses CatalogInventoryStockItemEntity::setQty()
     * @uses CatalogInventoryStockItemEntity::setIs_in_stock()
     * @param string $product_id
     * @param string $sku
     * @param string $qty
     * @param string $is_in_stock
     */
    public function __construct($product_id = null, $sku = null, $qty = null, $is_in_stock = null)
    {
        $this
            ->setProduct_id($product_id)
            ->setSku($sku)
            ->setQty($qty)
            ->setIs_in_stock($is_in_stock);
    }
    /**
     * Get product_id value
     * @return string|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemEntity
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get qty value
     * @return string|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemEntity
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qty)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get is_in_stock value
     * @return string|null
     */
    public function getIs_in_stock()
    {
        return $this->is_in_stock;
    }
    /**
     * Set is_in_stock value
     * @param string $is_in_stock
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemEntity
     */
    public function setIs_in_stock($is_in_stock = null)
    {
        // validation for constraint: string
        if (!is_null($is_in_stock) && !is_string($is_in_stock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($is_in_stock)), __LINE__);
        }
        $this->is_in_stock = $is_in_stock;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogInventoryStockItemEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
