<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogCategoryUpdateRequestParam StructType
 * @subpackage Structs
 */
class CatalogCategoryUpdateRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The categoryId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $categoryId;
    /**
     * The categoryData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntityCreate
     */
    public $categoryData;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for catalogCategoryUpdateRequestParam
     * @uses CatalogCategoryUpdateRequestParam::setSessionId()
     * @uses CatalogCategoryUpdateRequestParam::setCategoryId()
     * @uses CatalogCategoryUpdateRequestParam::setCategoryData()
     * @uses CatalogCategoryUpdateRequestParam::setStore()
     * @param string $sessionId
     * @param int $categoryId
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntityCreate $categoryData
     * @param string $store
     */
    public function __construct($sessionId = null, $categoryId = null, \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntityCreate $categoryData = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setCategoryId($categoryId)
            ->setCategoryData($categoryData)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !is_numeric($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get categoryData value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntityCreate
     */
    public function getCategoryData()
    {
        return $this->categoryData;
    }
    /**
     * Set categoryData value
     * @param \App\Api\Client\Magento\Type\StructType\CatalogCategoryEntityCreate $categoryData
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam
     */
    public function setCategoryData(\App\Api\Client\Magento\Type\StructType\CatalogCategoryEntityCreate $categoryData = null)
    {
        $this->categoryData = $categoryData;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryUpdateRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
