<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogCategoryTreeRequestParam StructType
 * @subpackage Structs
 */
class CatalogCategoryTreeRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The parentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $parentId;
    /**
     * The store
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $store;
    /**
     * Constructor method for catalogCategoryTreeRequestParam
     * @uses CatalogCategoryTreeRequestParam::setSessionId()
     * @uses CatalogCategoryTreeRequestParam::setParentId()
     * @uses CatalogCategoryTreeRequestParam::setStore()
     * @param string $sessionId
     * @param string $parentId
     * @param string $store
     */
    public function __construct($sessionId = null, $parentId = null, $store = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setParentId($parentId)
            ->setStore($store);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get parentId value
     * @return string
     */
    public function getParentId()
    {
        return $this->parentId;
    }
    /**
     * Set parentId value
     * @param string $parentId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeRequestParam
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentId)), __LINE__);
        }
        $this->parentId = $parentId;
        return $this;
    }
    /**
     * Get store value
     * @return string|null
     */
    public function getStore()
    {
        return $this->store;
    }
    /**
     * Set store value
     * @param string $store
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeRequestParam
     */
    public function setStore($store = null)
    {
        // validation for constraint: string
        if (!is_null($store) && !is_string($store)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($store)), __LINE__);
        }
        $this->store = $store;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryTreeRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
