<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogCategoryDeleteRequestParam StructType
 * @subpackage Structs
 */
class CatalogCategoryDeleteRequestParam extends AbstractStructBase
{
    /**
     * The sessionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sessionId;
    /**
     * The categoryId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $categoryId;
    /**
     * Constructor method for catalogCategoryDeleteRequestParam
     * @uses CatalogCategoryDeleteRequestParam::setSessionId()
     * @uses CatalogCategoryDeleteRequestParam::setCategoryId()
     * @param string $sessionId
     * @param int $categoryId
     */
    public function __construct($sessionId = null, $categoryId = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setCategoryId($categoryId);
    }
    /**
     * Get sessionId value
     * @return string
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteRequestParam
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get categoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteRequestParam
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !is_numeric($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogCategoryDeleteRequestParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
