<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogAttributeOptionEntity StructType
 * @subpackage Structs
 */
class CatalogAttributeOptionEntity extends AbstractStructBase
{
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for catalogAttributeOptionEntity
     * @uses CatalogAttributeOptionEntity::setLabel()
     * @uses CatalogAttributeOptionEntity::setValue()
     * @param string $label
     * @param string $value
     */
    public function __construct($label = null, $value = null)
    {
        $this
            ->setLabel($label)
            ->setValue($value);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeOptionEntity
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeOptionEntity
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAttributeOptionEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
