<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogAssignedProduct StructType
 * @subpackage Structs
 */
class CatalogAssignedProduct extends AbstractStructBase
{
    /**
     * The product_id
     * @var int
     */
    public $product_id;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The set
     * @var int
     */
    public $set;
    /**
     * The sku
     * @var string
     */
    public $sku;
    /**
     * The position
     * @var int
     */
    public $position;
    /**
     * Constructor method for catalogAssignedProduct
     * @uses CatalogAssignedProduct::setProduct_id()
     * @uses CatalogAssignedProduct::setType()
     * @uses CatalogAssignedProduct::setSet()
     * @uses CatalogAssignedProduct::setSku()
     * @uses CatalogAssignedProduct::setPosition()
     * @param int $product_id
     * @param string $type
     * @param int $set
     * @param string $sku
     * @param int $position
     */
    public function __construct($product_id = null, $type = null, $set = null, $sku = null, $position = null)
    {
        $this
            ->setProduct_id($product_id)
            ->setType($type)
            ->setSet($set)
            ->setSku($sku)
            ->setPosition($position);
    }
    /**
     * Get product_id value
     * @return int|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param int $product_id
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAssignedProduct
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: int
        if (!is_null($product_id) && !is_numeric($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAssignedProduct
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get set value
     * @return int|null
     */
    public function getSet()
    {
        return $this->set;
    }
    /**
     * Set set value
     * @param int $set
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAssignedProduct
     */
    public function setSet($set = null)
    {
        // validation for constraint: int
        if (!is_null($set) && !is_numeric($set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($set)), __LINE__);
        }
        $this->set = $set;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAssignedProduct
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get position value
     * @return int|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param int $position
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAssignedProduct
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\CatalogAssignedProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
