<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Store ServiceType
 * @subpackage Services
 */
class Store extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named storeList
     * Meta informations extracted from the WSDL
     * - documentation: List of stores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\StoreListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\StoreListResponseParam|bool
     */
    public function storeList(\App\Api\Client\Magento\Type\StructType\StoreListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named storeInfo
     * Meta informations extracted from the WSDL
     * - documentation: Store view info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\StoreInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\StoreInfoResponseParam|bool
     */
    public function storeInfo(\App\Api\Client\Magento\Type\StructType\StoreInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->storeInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\StoreInfoResponseParam|\App\Api\Client\Magento\Type\StructType\StoreListResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
