<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Shopping ServiceType
 * @subpackage Services
 */
class Shopping extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named shoppingCartCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCreateResponseParam|bool
     */
    public function shoppingCartCreate(\App\Api\Client\Magento\Type\StructType\ShoppingCartCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve information about shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartInfoResponseParam|bool
     */
    public function shoppingCartInfo(\App\Api\Client\Magento\Type\StructType\ShoppingCartInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartTotals
     * Meta informations extracted from the WSDL
     * - documentation: Get total prices for shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartTotalsRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartTotalsResponseParam|bool
     */
    public function shoppingCartTotals(\App\Api\Client\Magento\Type\StructType\ShoppingCartTotalsRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartTotals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartOrder
     * Meta informations extracted from the WSDL
     * - documentation: Create an order from shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartOrderRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartOrderResponseParam|bool
     */
    public function shoppingCartOrder(\App\Api\Client\Magento\Type\StructType\ShoppingCartOrderRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartLicense
     * Meta informations extracted from the WSDL
     * - documentation: Get terms and conditions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseResponseParam|bool
     */
    public function shoppingCartLicense(\App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartLicense($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartProductAdd
     * Meta informations extracted from the WSDL
     * - documentation: Add product(s) to shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartProductAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductAddResponseParam|bool
     */
    public function shoppingCartProductAdd(\App\Api\Client\Magento\Type\StructType\ShoppingCartProductAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartProductAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartProductUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update product(s) quantities in shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartProductUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductUpdateResponseParam|bool
     */
    public function shoppingCartProductUpdate(\App\Api\Client\Magento\Type\StructType\ShoppingCartProductUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartProductUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartProductRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove product(s) from shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartProductRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductRemoveResponseParam|bool
     */
    public function shoppingCartProductRemove(\App\Api\Client\Magento\Type\StructType\ShoppingCartProductRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartProductRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartProductList
     * Meta informations extracted from the WSDL
     * - documentation: Get list of products in shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartProductListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductListResponseParam|bool
     */
    public function shoppingCartProductList(\App\Api\Client\Magento\Type\StructType\ShoppingCartProductListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartProductList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * shoppingCartProductMoveToCustomerQuote
     * Meta informations extracted from the WSDL
     * - documentation: Move product(s) to customer quote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartProductMoveToCustomerQuoteRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductMoveToCustomerQuoteResponseParam|bool
     */
    public function shoppingCartProductMoveToCustomerQuote(\App\Api\Client\Magento\Type\StructType\ShoppingCartProductMoveToCustomerQuoteRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartProductMoveToCustomerQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartCustomerSet
     * Meta informations extracted from the WSDL
     * - documentation: Set customer for shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetResponseParam|bool
     */
    public function shoppingCartCustomerSet(\App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartCustomerSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartCustomerAddresses
     * Meta informations extracted from the WSDL
     * - documentation: Set customer's addresses in shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressesRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressesResponseParam|bool
     */
    public function shoppingCartCustomerAddresses(\App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressesRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartCustomerAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartShippingMethod
     * Meta informations extracted from the WSDL
     * - documentation: Set shipping method
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartShippingMethodRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartShippingMethodResponseParam|bool
     */
    public function shoppingCartShippingMethod(\App\Api\Client\Magento\Type\StructType\ShoppingCartShippingMethodRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartShippingMethod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartShippingList
     * Meta informations extracted from the WSDL
     * - documentation: Get list of available shipping methods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartShippingListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartShippingListResponseParam|bool
     */
    public function shoppingCartShippingList(\App\Api\Client\Magento\Type\StructType\ShoppingCartShippingListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartShippingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartPaymentMethod
     * Meta informations extracted from the WSDL
     * - documentation: Set payment method
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodResponseParam|bool
     */
    public function shoppingCartPaymentMethod(\App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartPaymentMethod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartPaymentList
     * Meta informations extracted from the WSDL
     * - documentation: Get list of available payment methods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentListResponseParam|bool
     */
    public function shoppingCartPaymentList(\App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartPaymentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartCouponAdd
     * Meta informations extracted from the WSDL
     * - documentation: Add coupon code for shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartCouponAddRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCouponAddResponseParam|bool
     */
    public function shoppingCartCouponAdd(\App\Api\Client\Magento\Type\StructType\ShoppingCartCouponAddRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartCouponAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shoppingCartCouponRemove
     * Meta informations extracted from the WSDL
     * - documentation: Remove coupon code from shopping cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ShoppingCartCouponRemoveRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCouponRemoveResponseParam|bool
     */
    public function shoppingCartCouponRemove(\App\Api\Client\Magento\Type\StructType\ShoppingCartCouponRemoveRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->shoppingCartCouponRemove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartCouponAddResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartCouponRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartCreateResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerAddressesResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartCustomerSetResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartInfoResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartLicenseResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartOrderResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentListResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartPaymentMethodResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartProductAddResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartProductListResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartProductMoveToCustomerQuoteResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartProductRemoveResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartProductUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartShippingListResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartShippingMethodResponseParam|\App\Api\Client\Magento\Type\StructType\ShoppingCartTotalsResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
