<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sales ServiceType
 * @subpackage Services
 */
class Sales extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named salesOrderList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of orders by filters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderListResponseParam|bool
     */
    public function salesOrderList(\App\Api\Client\Magento\Type\StructType\SalesOrderListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve order information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInfoResponseParam|bool
     */
    public function salesOrderInfo(\App\Api\Client\Magento\Type\StructType\SalesOrderInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderAddComment
     * Meta informations extracted from the WSDL
     * - documentation: Add comment to order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentResponseParam|bool
     */
    public function salesOrderAddComment(\App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderAddComment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderHold
     * Meta informations extracted from the WSDL
     * - documentation: Hold order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderHoldRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderHoldResponseParam|bool
     */
    public function salesOrderHold(\App\Api\Client\Magento\Type\StructType\SalesOrderHoldRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderHold($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderUnhold
     * Meta informations extracted from the WSDL
     * - documentation: Unhold order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderUnholdRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderUnholdResponseParam|bool
     */
    public function salesOrderUnhold(\App\Api\Client\Magento\Type\StructType\SalesOrderUnholdRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderUnhold($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderCancel
     * Meta informations extracted from the WSDL
     * - documentation: Cancel order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCancelRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCancelResponseParam|bool
     */
    public function salesOrderCancel(\App\Api\Client\Magento\Type\StructType\SalesOrderCancelRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of shipments by filters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentListResponseParam|bool
     */
    public function salesOrderShipmentList(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve shipment information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentInfoResponseParam|bool
     */
    public function salesOrderShipmentInfo(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create new shipment for order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateResponseParam|bool
     */
    public function salesOrderShipmentCreate(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentAddComment
     * Meta informations extracted from the WSDL
     * - documentation: Add new comment to shipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentResponseParam|bool
     */
    public function salesOrderShipmentAddComment(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentAddComment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentAddTrack
     * Meta informations extracted from the WSDL
     * - documentation: Add new tracking number
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackResponseParam|bool
     */
    public function salesOrderShipmentAddTrack(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentAddTrack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentRemoveTrack
     * Meta informations extracted from the WSDL
     * - documentation: Remove tracking number
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackResponseParam|bool
     */
    public function salesOrderShipmentRemoveTrack(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentRemoveTrack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentSendInfo
     * Meta informations extracted from the WSDL
     * - documentation: Send shipment info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoResponseParam|bool
     */
    public function salesOrderShipmentSendInfo(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentSendInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderShipmentGetCarriers
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of allowed carriers for order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentGetCarriersRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderShipmentGetCarriersResponseParam|bool
     */
    public function salesOrderShipmentGetCarriers(\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentGetCarriersRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderShipmentGetCarriers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInvoiceList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of invoices by filters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceListResponseParam|bool
     */
    public function salesOrderInvoiceList(\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInvoiceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInvoiceInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve invoice information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoResponseParam|bool
     */
    public function salesOrderInvoiceInfo(\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInvoiceInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInvoiceCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create new invoice for order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCreateResponseParam|bool
     */
    public function salesOrderInvoiceCreate(\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInvoiceCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInvoiceAddComment
     * Meta informations extracted from the WSDL
     * - documentation: Add new comment to shipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentResponseParam|bool
     */
    public function salesOrderInvoiceAddComment(\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInvoiceAddComment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInvoiceCapture
     * Meta informations extracted from the WSDL
     * - documentation: Capture invoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCaptureRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCaptureResponseParam|bool
     */
    public function salesOrderInvoiceCapture(\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCaptureRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInvoiceCapture($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInvoiceVoid
     * Meta informations extracted from the WSDL
     * - documentation: Void invoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceVoidRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceVoidResponseParam|bool
     */
    public function salesOrderInvoiceVoid(\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceVoidRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInvoiceVoid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderInvoiceCancel
     * Meta informations extracted from the WSDL
     * - documentation: Cancel invoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCancelRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCancelResponseParam|bool
     */
    public function salesOrderInvoiceCancel(\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCancelRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderInvoiceCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderCreditmemoList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve list of creditmemos by filters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoListResponseParam|bool
     */
    public function salesOrderCreditmemoList(\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderCreditmemoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderCreditmemoInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve creditmemo information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoInfoResponseParam|bool
     */
    public function salesOrderCreditmemoInfo(\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderCreditmemoInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderCreditmemoCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create new creditmemo for order
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateResponseParam|bool
     */
    public function salesOrderCreditmemoCreate(\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderCreditmemoCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderCreditmemoAddComment
     * Meta informations extracted from the WSDL
     * - documentation: Add new comment to creditmemo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentResponseParam|bool
     */
    public function salesOrderCreditmemoAddComment(\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderCreditmemoAddComment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named salesOrderCreditmemoCancel
     * Meta informations extracted from the WSDL
     * - documentation: Cancel creditmemo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCancelRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCancelResponseParam|bool
     */
    public function salesOrderCreditmemoCancel(\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCancelRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->salesOrderCreditmemoCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\SalesOrderAddCommentResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderCancelResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoAddCommentResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCancelResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoCreateResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoInfoResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderCreditmemoListResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderHoldResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInfoResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceAddCommentResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCancelResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCaptureResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceCreateResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceInfoResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceListResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderInvoiceVoidResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderListResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddCommentResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentAddTrackResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentCreateResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentGetCarriersResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentInfoResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentListResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentRemoveTrackResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderShipmentSendInfoResponseParam|\App\Api\Client\Magento\Type\StructType\SalesOrderUnholdResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
