<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resources ServiceType
 * @subpackage Services
 */
class Resources extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named resources
     * Meta informations extracted from the WSDL
     * - documentation: List of available resources
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\ResourcesRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\ResourcesResponseParam|bool
     */
    public function resources(\App\Api\Client\Magento\Type\StructType\ResourcesRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->resources($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\ResourcesResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
