<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Multi ServiceType
 * @subpackage Services
 */
class Multi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named multiCall
     * Meta informations extracted from the WSDL
     * - documentation: Multiple calls of resource functionality
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\MultiCallParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\MultiCallResponseParam|bool
     */
    public function multiCall(\App\Api\Client\Magento\Type\StructType\MultiCallParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->multiCall($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\MultiCallResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
