<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Magento ServiceType
 * @subpackage Services
 */
class Magento extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named magentoInfo
     * Meta informations extracted from the WSDL
     * - documentation: Info about current Magento installation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\MagentoInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\MagentoInfoResponseParam|bool
     */
    public function magentoInfo(\App\Api\Client\Magento\Type\StructType\MagentoInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->magentoInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\MagentoInfoResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
