<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gift ServiceType
 * @subpackage Services
 */
class Gift extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named giftMessageSetForQuote
     * Meta informations extracted from the WSDL
     * - documentation: Set a gift message to the cart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteResponseParam|bool
     */
    public function giftMessageSetForQuote(\App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->giftMessageSetForQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named giftMessageSetForQuoteItem
     * Meta informations extracted from the WSDL
     * - documentation: Setting a gift messages to the quote item
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemResponseParam|bool
     */
    public function giftMessageSetForQuoteItem(\App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->giftMessageSetForQuoteItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named giftMessageSetForQuoteProduct
     * Meta informations extracted from the WSDL
     * - documentation: Setting a gift messages to the quote items by products
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductResponseParam|bool
     */
    public function giftMessageSetForQuoteProduct(\App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->giftMessageSetForQuoteProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteItemResponseParam|\App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteProductResponseParam|\App\Api\Client\Magento\Type\StructType\GiftMessageForQuoteResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
