<?php

namespace App\Api\Client\Magento\Type\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named customerCustomerList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve customers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerCustomerListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerListResponseParam|bool
     */
    public function customerCustomerList(\App\Api\Client\Magento\Type\StructType\CustomerCustomerListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerCustomerList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerCustomerCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create customer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateResponseParam|bool
     */
    public function customerCustomerCreate(\App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerCustomerCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerCustomerInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve customer data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerCustomerInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerInfoResponseParam|bool
     */
    public function customerCustomerInfo(\App\Api\Client\Magento\Type\StructType\CustomerCustomerInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerCustomerInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerCustomerUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update customer data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerCustomerUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerUpdateResponseParam|bool
     */
    public function customerCustomerUpdate(\App\Api\Client\Magento\Type\StructType\CustomerCustomerUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerCustomerUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerCustomerDelete
     * Meta informations extracted from the WSDL
     * - documentation: Delete customer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerCustomerDeleteRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerCustomerDeleteResponseParam|bool
     */
    public function customerCustomerDelete(\App\Api\Client\Magento\Type\StructType\CustomerCustomerDeleteRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerCustomerDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerGroupList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve customer groups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerGroupListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerGroupListResponseParam|bool
     */
    public function customerGroupList(\App\Api\Client\Magento\Type\StructType\CustomerGroupListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerGroupList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerAddressList
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve customer addresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressListRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressListResponseParam|bool
     */
    public function customerAddressList(\App\Api\Client\Magento\Type\StructType\CustomerAddressListRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerAddressList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerAddressCreate
     * Meta informations extracted from the WSDL
     * - documentation: Create customer address
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateResponseParam|bool
     */
    public function customerAddressCreate(\App\Api\Client\Magento\Type\StructType\CustomerAddressCreateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerAddressCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerAddressInfo
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve customer address data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressInfoRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressInfoResponseParam|bool
     */
    public function customerAddressInfo(\App\Api\Client\Magento\Type\StructType\CustomerAddressInfoRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerAddressInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerAddressUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Update customer address data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateResponseParam|bool
     */
    public function customerAddressUpdate(\App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerAddressUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named customerAddressDelete
     * Meta informations extracted from the WSDL
     * - documentation: Delete customer address
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Api\Client\Magento\Type\StructType\CustomerAddressDeleteRequestParam $parameters
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressDeleteResponseParam|bool
     */
    public function customerAddressDelete(\App\Api\Client\Magento\Type\StructType\CustomerAddressDeleteRequestParam $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->customerAddressDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Api\Client\Magento\Type\StructType\CustomerAddressCreateResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerAddressDeleteResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerAddressInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerAddressListResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerAddressUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerCustomerCreateResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerCustomerDeleteResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerCustomerInfoResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerCustomerListResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerCustomerUpdateResponseParam|\App\Api\Client\Magento\Type\StructType\CustomerGroupListResponseParam
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
